import { FormInput } from "../controller.js";

/**
 * 开关组件
 * @param {[type]} dataModel [description]
 */
export default class Switch extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Switch", dataModel, parent);
  }

  //属性
  get value() {
    return this.dataModel.value;
  }
  set value(value) {
    this.dataModel.value = value;
    
    if (this._jqObj) {
      if ((value + "") == (this.dataModel.options[1] + "")) {
        this._jqObj.attr("checked", "checked");
      } else {
        this._jqObj.removeAttr("checked");
      }
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get options() { return this.dataModel.options }
  set options(value) {
    if (!value) return;
    if (typeof (value) == "string") {
      this.dataModel.options = value.split(",");
    } else if (Array.isArray(value)) {
      this.dataModel.options = value;
    }
  }

  get controlColor() { return this.dataModel.controlColor }
  set controlColor(value) {
    this.dataModel.controlColor = value;
  }

  initRuntime() {
    let that = this;
    this._jqObj.click(function () {
      if (that.dataModel.value == that.dataModel.options[1]) {
        that.value = that.dataModel.options[0];
      } else {
        that.value = that.dataModel.options[1];
      }
    });
  }
}