import { FormInput } from "../controller.js";

/**
 * 开关组件
 * @param {[type]} dataModel [description]
 */
export default class Switch extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Switch", dataModel, parent);
  }

  //属性
  get value() {
    if (this._jqObj) {
      if (this._jqObj.find("div").css("float") == "right") {
        this.dataModel.value = this.dataModel.options[1];
      } else {
        this.dataModel.value = this.dataModel.options[0];
      }
    }
    /*if(this.dataModel.value==undefined || this.dataModel.value==null) {
      if(this.dataModel.options && this.dataModel.options.length>0) 
        this.dataModel.value = this.dataModel.options[0];
    }*/
    return this.dataModel.value;
  }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      if ((value + "") == (this.dataModel.options[1] + "")) {
        this._jqObj.find("div").css("float", "right");
        this._jqObj.find("div").attr("class", "tfp-switch-color");
      } else {
        this._jqObj.find("div").css("float", "left");
        this._jqObj.find("div").attr("class", "tfp-switch-nocolor");
      }
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get options() { return this.dataModel.options }
  set options(value) {
    if (!value) return;
    if (typeof (value) == "string") {
      this.dataModel.options = value.split(",");
    } else if (Array.isArray(value)) {
      this.dataModel.options = value;
    }
  }

  initRuntime() {
    let that = this;

    this._jqObj.click(function () {
      if (that.readonly || that.disabled) return;
      if (that.dataModel.value == that.dataModel.options[1]) {
        that.value = that.dataModel.options[0];
      } else {
        that.value = that.dataModel.options[1];
      }
    });
  }
}