import TFPComponentRender from '../render.js'

export default class SwiperRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let val = "";
    html += indent;
    if (!this.dataModel.options) {
      this.dataModel.options = [{
        "srcJson": {
          "type": "httpurl",
          "url": "http://www.taskbuilder.org/tbsite/images/loadpage.png"
        },
        "swipersrc": "http://www.taskbuilder.org/tbsite/images/loadpage.png",
      }]
    }
    html += indent;
    let option = this.dataModel.options[0];
    if (option && option.swipersrc) {
      html += `<div class="swiper_imageBox" style="height: fit-content;">`;
      let src = option.srcJson.url;
      if (option.srcJson.type == 'url') {
        src = this._tfp.getUrlRealPath(src);
      }
      html += `<img class="wx-image" src="` + src + `" style=" width:100%; height:100%;user-select:none; ">\n`;
      html += "</div>\r\n";
    }
    return html + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    bodyHtml += indent + "";
    bodyHtml += `\t<swiper `;
    if (this.dataModel.indicatorDots) {
      bodyHtml += ` indicator-dots="` + this.dataModel.indicatorDots + `"`;
    }
    if (this.dataModel.autoplay) {
      bodyHtml += ` autoplay="` + this.dataModel.autoplay + `"`;
    }
    if (this.dataModel.circular) {
      bodyHtml += ` circular="` + this.dataModel.circular + `"`;
    }
    if (this.dataModel.vertical) {
      bodyHtml += ` vertical="` + this.dataModel.vertical + `"`;
    }
    if (this.dataModel.interval) {
      bodyHtml += ` interval="` + this.dataModel.interval + `"`;
    }
    if (this.dataModel.duration) {
      bodyHtml += ` duration="` + this.dataModel.duration + `"`;
    }
    bodyHtml += ` previous-margin="` + this.dataModel.previousMargin + `px" next-margin="` + this.dataModel.nextMargin + `px" style="height: {{swiperHeight}};">\n`;
    bodyHtml += `\t\t\t<block wx:for="{{` + this.dataModel.id + `_array}}" wx:key="*this">\n`;
    bodyHtml += `\t\t\t\t<swiper-item>\n`;
    bodyHtml += `\t\t\t\t\t<view class="swiper-item">\n`;
    bodyHtml += `\t\t\t\t\t\t<image src="{{item}}" style="width: 100%;height:{{swiperHeight}};" data-index="{{index}}"/>\n`;
    bodyHtml += `\t\t\t\t\t</view>\n`;
    bodyHtml += `\t\t\t\t</swiper-item>\n`;
    bodyHtml += `\t\t\t</block>\n`;
    bodyHtml += `\t\t</swiper>\n`;
    // bodyHtml += "\t\t</view>\r\n";
    cpt_wx.wxml = bodyHtml + indent;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", false, parentIndent, retainStyleAttr, otherOptions);
  }
}