import TFPComponentRender from '../render.js'

export default class SwiperRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getFirstBannerUrl() {
    if(this.dataModel.options.length==0) return "";
    let option = this.dataModel.options[0];
    let src = " ";
    if (option && option.src) {
      if (option.src.substring(0, 4) == '/src') {
        src = this._tfp.rootPath + option.src;
      } else if (option.src.substring(0, 4) == '/app') {
        src = this._tfp.getUrlRealPath(option.src);
      } else if (option.src.indexOf("/") == -1) {
        src = "/Download?fileCode=" + option.src;
      } else {
        src = option.src;
      }
    }
    return src;
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    if(this._tfp.isDesigning) return "";
    let html = "\r\n";
    let indent = this.getHtmlIndent();

    html += indent + `<div>`;
    html += `<img src="` + this.getFirstBannerUrl() + `" style=" width:100%; height:100%;user-select:none; ">\n`;
    html += "</div>\r\n";
    return html + indent;
  }

  //设计时，为了实现拖拽调整位置，需要用div+背景图片的形式，直接用图片无法拖拽
  getCustomStyleHtml() {
    if(this._tfp.isDesigning) {
      return "background-image:url("+this.getFirstBannerUrl()+");background-size:"
        +this.dataModel.styles["width"]+" "+this.dataModel.styles["height"]+";";
    }
    return "";
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}