import { FormInput } from "../controller.js";

/**
 * 面板组件
 * @param {[type]} dataModel [description]
 */
export default class Swiper extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Swiper", dataModel, parent);
  }

  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) { this.dataModel.dataBindingMember = value }

  get srcField() { return this.dataModel.srcField }
  set srcField(value) { this.dataModel.srcField = value }

  loadData() {
    if (!this.dataModel.loadDataService) {
      alert("请为[" + this.id + "]设置加载数据服务！");
      return;
    }
    let serviceCpt = this._tfp.get(this.dataModel.loadDataService);
    if (!serviceCpt) {
      alert("ID为[" + this.dataModel.loadDataService + "]的组件不存在！");
      return;
    }
    if (!this.dataModel.dataBindingMember) {
      alert("请为[" + this.id + "]设置数据绑定成员！");
      return;
    }
    if (!this.dataModel.srcField) {
      alert("请为[" + this.id + "]设置图片路径！");
      return;
    }

    let that = this;
    serviceCpt.request(null, function (req, res) {
      var data = res[that.dataModel.dataBindingMember];
      that.bindData(data);
    });
  }


  initRuntime() {
    if (this.dataModel.loadDataService) {
      this.loadData();
    } else {
      if (this._jqObj) {
        this._jqObj.empty();
        this.addOption(value[0], true, 0);
      }
    }
  }



  // 选项
  get options() {
    return this.dataModel.options;
  }
  set options(value) {
    if (!value) return;
    let options = [];
    if (typeof (value) == "string") {
      let arr = value.split(",");
      for (var i = 0; i < arr.length; i++) {
        let str = arr[i];
        if (str.trim() != "") {
          options.push({
            value: str,
            text: str
          });
        }
      }
    } else if (Array.isArray(value)) {
      for (var i = 0; i < value.length; i++) {
        let val = value[i];
        if (Object.prototype.toString.call(val) === '[object Object]') {
          options.push(val);
        } else {
          options.push({
            value: val,
            text: val
          });
        }
      }
    }
    this.dataModel.options = options;
    if (this._jqObj) {
      this._jqObj.empty();
      if(value.length>0){
        this.addOption(value[0], true, 0);
      }
    }
  }


  addOption(option, isInit, index) {
    let indent = this.getHtmlIndent();
    let str = "";
    str += this.getOptionHtml(indent, option, index);
    if (str != "") {
      this._jqObj.append(str);
      if (!isInit) this.dataModel.options.push(option);
    }
  }

  getOptionHtml(indent, option, index) {
    let optionHtml = "";
    if (option.swipersrc) {
      optionHtml += indent;
      optionHtml += `<div class="swiper_imageBox" style="height: fit-content;">`;
      let src = option.srcJson.url;
      if (option.srcJson.type == 'url') {
        src = this._tfp.getUrlRealPath(src);
      }
      optionHtml += `<img class="wx-image" src="` + src + `" style=" width:100%; height:100%;user-select:none; ">\n`;
      optionHtml += "</div>\r\n";
    }
    return optionHtml;
  }

  //组件提示
  get title() { return this.dataModel.title }
  set title(value) {
    this.dataModel.title = value;
    if (this._jqObj) this._jqObj.attr("title", value);
  }

  // 自动播放间隔时长(ms)
  get interval() { return this.dataModel.interval }
  set interval(value) {
    this.dataModel.interval = value;
  }

  // 幻灯片切换时长(ms)
  get duration() { return this.dataModel.duration }
  set duration(value) {
    this.dataModel.duration = value;
  }

  // 前边距(px)
  get previousMargin() { return this.dataModel.previousMargin }
  set previousMargin(value) {
    this.dataModel.previousMargin = value;
  }

  // 后边距(px)
  get nextMargin() { return this.dataModel.nextMargin }
  set nextMargin(value) {
    this.dataModel.nextMargin = value;
  }

  //宽高比
  get aspectRatio() { return this.dataModel.aspectRatio }
  set aspectRatio(value) {
    this.dataModel.aspectRatio = value;
  }

  // 是否自动播放
  get autoplay() { return this.dataModel.autoplay }
  set autoplay(value) {
    this.dataModel.autoplay = value;
  }

  // 是否竖向展示
  get vertical() { return this.dataModel.vertical }
  set vertical(value) {
    if (value == 'true') {
      this.dataModel.vertical = value;
    } else {
      this.dataModel.vertical = '';
    }
  }

  // 是否展示指示点
  get indicatorDots() { return this.dataModel.indicatorDots }
  set indicatorDots(value) {
    this.dataModel.indicatorDots = value;
  }

  // 是否衔接滑动
  get circular() { return this.dataModel.circular }
  set circular(value) {
    this.dataModel.circular = value;
  }
}