import { FormInput } from "../controller.js";

/**
 * 轮播图组件
 * @param {[type]} dataModel [description]
 */
export default class Swiper extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Swiper", dataModel, parent);

    if (!this.dataModel.options) {
      this.dataModel.options = [{
        src: "/src/components/swiper/images/banner1.png",
        title: "任讯 TaskMSG",
        text: "任讯 TaskMSG",
        targetTitle: "TaskBuilder - 更专业的低代码开发工具",
        href: "http://taskbuilder.taskmsg.com/index.html"
      },
      {
        src: "/src/components/swiper/images/banner2.png",
        title: "任擎 Tasgine",
        text: "任擎 Tasgine",
        targetTitle: "TaskBuilder - 更专业的低代码开发工具",
        href: "http://taskbuilder.taskmsg.com/index.html"
      },
      {
        src: "/src/components/swiper/images/banner3.png",
        title: "任构 TaskBuilder",
        text: "任构 TaskBuilder",
        targetTitle: "TaskBuilder - 更专业的低代码开发工具",
        href: "http://taskbuilder.taskmsg.com/index.html"
      },
      {
        src: "/src/components/swiper/images/banner4.png",
        title: "任流 TaskFlow",
        text: "任流 TaskFlow",
        targetTitle: "TaskBuilder - 更专业的低代码开发工具",
        href: "http://taskbuilder.taskmsg.com/index.html"
      },
      {
        src: "/src/components/swiper/images/banner5.png",
        title: "任讯 TaskMSG",
        text: "任讯 TaskMSG",
        targetTitle: "TaskBuilder - 更专业的低代码开发工具",
        href: "http://taskbuilder.taskmsg.com/index.html"
      }];
    }
  }

  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) { this.dataModel.dataBindingMember = value }

  get srcField() { return this.dataModel.srcField }
  set srcField(value) { this.dataModel.srcField = value }

  get imgtitleField() { return this.dataModel.imgtitleField }
  set imgtitleField(value) { this.dataModel.imgtitleField = value }

  get textField() { return this.dataModel.textField }
  set textField(value) { this.dataModel.textField = value }

  get titleField() { return this.dataModel.titleField }
  set titleField(value) { this.dataModel.titleField = value }

  get hrefField() { return this.dataModel.hrefField }
  set hrefField(value) { this.dataModel.hrefField = value }
 
  bindData(data) {
    if (isNull(data) || !Array.isArray(data)) return;
    let options = [];
    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {};
      try {
        let srcField = "src";
        if (this.dataModel.srcField) srcField = this.dataModel.srcField;
        if (srcField.indexOf("{") < 0 && srcField.indexOf("#[") < 0) srcField = "{" + srcField + "}";
        option.src = this._tfp.replaceDataField(row, srcField);
        if (option.src) option.src = this._tfp.exeExpress(option.src);
      } catch (e) {
        console.log(e);
        return;
      }
      if (isNull(option.src)) continue;
      try {
        let textField = "text";
        if (this.dataModel.textField) textField = this.dataModel.textField;
        if (textField.indexOf("{") < 0 && textField.indexOf("#[") < 0) textField = "{" + textField + "}";
        option.text = this._tfp.replaceDataField(row, textField);
        if (option.text) option.text = this._tfp.exeExpress(option.text);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let imgtitleField = "imgtitle";
        if (this.dataModel.imgtitleField) imgtitleField = this.dataModel.imgtitleField;
        if (imgtitleField.indexOf("{") < 0 && imgtitleField.indexOf("#[") < 0) imgtitleField = "{" + imgtitleField + "}";
        option.title = this._tfp.replaceDataField(row, imgtitleField);
        if (option.title) option.title = this._tfp.exeExpress(option.title);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let titleField = "title";
        if (this.dataModel.titleField) titleField = this.dataModel.titleField;
        if (titleField.indexOf("{") < 0 && titleField.indexOf("#[") < 0) titleField = "{" + titleField + "}";
        option.targetTitle = this._tfp.replaceDataField(row, titleField);
        if (option.targetTitle) option.targetTitle = this._tfp.exeExpress(option.targetTitle);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let hrefField = "href";
        if (this.dataModel.hrefField) hrefField = this.dataModel.hrefField;
        if (hrefField.indexOf("{") < 0 && hrefField.indexOf("#[") < 0) hrefField = "{" + hrefField + "}";
        option.href = this._tfp.replaceDataField(row, hrefField);
        if (option.href) option.href = this._tfp.exeExpress(option.href);
      } catch (e) {
        console.log(e);
        return;
      }
      options.push(option);
    }
    this.options = options;
  }

  // 选项
  get options() { return this.dataModel.options }
  set options(options) {
    if (this._jqObj && options && Array.isArray(options)) {
      this.dataModel.options = options;
      if (!this._tfp.isDesigning) {
        this.setImages();
        this.onChangeImages();
      }
    }
  }

  // 目标页面
  get target() { return this.dataModel.target }
  set target(value) {
    this.dataModel.target = value;
  }

  // 自动播放间隔时长(ms)
  get interval() { return this.dataModel.interval }
  set interval(value) {
    this.dataModel.interval = value;
  }

  // 是否自动播放
  get autoplay() { return this.dataModel.autoplay }
  set autoplay(value) {
    this.dataModel.autoplay = value ? true : false;
  }

  // 是否展示指示点
  get indicatorDots() { return this.dataModel.indicatorDots }
  set indicatorDots(value) {
    this.dataModel.indicatorDots = value ? true : false;
  }

  setImages() {
    let swiperHtml = `<div id="tfp-swiper-container">
        <div id="tfp-swiper-list" style="width:`+ (this.dataModel.options.length + 2) * this._jqObj.width() + `px;left: -` + this._jqObj.width() + `px;">`;
    let option = this.dataModel.options[this.dataModel.options.length - 1];
    if (option && option.src) {
      let src = option.src;
      if (option.src.substring(0, 4) == '/src') {
        src = this._tfp.rootPath + option.src;
      } else if (option.src.substring(0, 4) == '/app') {
        src = this._tfp.getUrlRealPath(option.src);
      } else if (option.src.indexOf("/") == -1) {
        src = "/Download?fileCode=" + option.src;
      } else {
        src = option.src;
      }
      swiperHtml += `<img src="` + src + `" style="width:` + this._jqObj.width() + `px;"/>`;
    }
    for (var i = 0; i < this.dataModel.options.length; i++) {
      let option1 = this.dataModel.options[i];
      if (option1 && option1.src) {
        let src = option1.src;
        if (option1.src.substring(0, 4) == '/src') {
          src = this._tfp.rootPath + option1.src;
        } else if (option1.src.substring(0, 4) == '/app') {
          src = this._tfp.getUrlRealPath(option1.src);
        } else if (option1.src.indexOf("/") == -1) {
          src = "/Download?fileCode=" + option1.src;
        } else {
          src = option1.src;
        }
        if (!option1.text) option1.text = "";
        if (!option1.targetTitle) option1.targetTitle = "Tasgine - 任擎";
        swiperHtml += `<a`;
        if (this.dataModel.target == "self") {
          swiperHtml += ` href="` + option1.href + `"`;
        } else if (this.dataModel.target == "page") {
          swiperHtml += ` href="javascript:void(0)" onclick="tfp.openPage('` + option1.targetTitle + `', '` + option1.href + `')"`;
        } else if (this.dataModel.target == "window") {
          swiperHtml += `  href="javascript:void(0)" onclick="window.open('` + option1.href + `', '` + option1.targetTitle + `')"`;
        }
        swiperHtml += `><img src="` + src + `" style="width:` + this._jqObj.width() + `px;" title="` + option1.text + `"/></a>`;
      }
    }
    let option2 = this.dataModel.options[0];
    if (option2 && option2.src) {
      let src = option2.src;
      if (option2.src.substring(0, 4) == '/src') {
        src = this._tfp.rootPath + option2.src;
      } else if (option2.src.substring(0, 4) == '/app') {
        src = this._tfp.getUrlRealPath(option2.src);
      } else if (option2.src.indexOf("/") == -1) {
        src = "/Download?fileCode=" + option2.src;
      } else {
        src = option2.src;
      }
      swiperHtml += `<img src="` + src + ` style="width:` + this._jqObj.width() + `px;"/>`;
    }
    swiperHtml += `</div>`;

    if (this.dataModel.indicatorDots) {
      swiperHtml += `<div id="tfp-swiper-points">`;
      for (var i = 1; i <= this.dataModel.options.length; i++) {
        if (i == 1) {
          swiperHtml += `<span index="` + i + `" class="tfp-swiper-on"></span>`;
        } else {
          swiperHtml += `<span index="` + i + `"></span>`;
        }
      }
      swiperHtml += `</div>`;
    }

    // 轮播图标题
    swiperHtml += `<div id="tfp-swiper-title">`;
    for (var i = 0; i < this.dataModel.options.length; i++) {
      let title = this.dataModel.options[i].title || '';
      if (i == 0) {
        swiperHtml += `<span index="` + i + `"`;
        if (title != '') swiperHtml += ` class="tfp-swiper-title-span"`;
        if (title == '') swiperHtml += ` style="display:none"`;
        swiperHtml += `>` + title + `</span>`;
      } else {
        swiperHtml += `<span index="` + i + `" style="display:none"`;
        if (title != '') swiperHtml += ` class="tfp-swiper-title-span"`;
        swiperHtml += `>` + title + `</span>`;
      }
    }
    swiperHtml += `</div>`;

    swiperHtml += `<a href="javascript:;" id="tfp-swiper-prev" class="tfp-swiper-arrow">&lt;</a>
                     <a href="javascript:;" id="tfp-swiper-next" class="tfp-swiper-arrow">&gt;</a>
                    </div>`;
    this._jqObj.html(swiperHtml)
  }

  onChangeImages() {
    var that = this;
    //得到所有照片的div
    var $div = $('#tfp-swiper-list');
    var $span = $('#tfp-swiper-points>span')
    //获取照片当前的位置
    var index = 1;
    var isToggleImagEnd = true;
    //点击按键往左移动
    $('#tfp-swiper-prev').click(function () {
      isToggleImg(0)
    });
    //点击按键往右移动
    $('#tfp-swiper-next').click(function () {
      isToggleImg(1)
    });

    function isToggleImg(n) {
      if (isToggleImagEnd) {
        isToggleImagEnd = false;
        if (n == 0) {
          index--;
        } else {
          index++;
        }
        $div.animate({
          left: index * (-that._jqObj.width())
        }, 500, function () {
          if (index == 0) {
            index = that.dataModel.options.length
          }
          if (index == that.dataModel.options.length + 1) {
            index = 1;
          }
          //设置图片轮播时，从最后一张跳到第一张不会有间隙，跟其他图片一样跳转
          $div.css('left', index * (-that._jqObj.width()))
          //设置图片下面的圆点状态，更改其类属性
          $span.removeClass('tfp-swiper-on');
          $($span.get(index - 1)).addClass('tfp-swiper-on')
          that._jqObj.find('#tfp-swiper-title').children('span').css('display', 'none');
          that._jqObj.find('#tfp-swiper-title').children('span').eq(index - 1).css('display', 'block');
          isToggleImagEnd = true;
        })
      }
    }

    if (that.dataModel.autoplay) {
      //设置延时函数，让图片自己定时轮播下一张
      var interval = setInterval(function () {
        isToggleImg(1);
      }, that.dataModel.interval)
      //鼠标图片上图片停止轮播，挪开继续轮播
      $("#tfp-swiper-container").hover(function () {
        clearInterval(interval)
      }, function () {
        interval = setInterval(function () {
          isToggleImg(1);
        }, that.dataModel.interval)
      })
    }
    //对小圆点设置监听事件，点击小圆点，图片跳转
    $span.click(function () {
      index = $(this).index();
      isToggleImg()
    })
  }

  /**
   * 检查数据加载参数是否设置正确
   * @returns 
   */
  checkLoadDataArg() {
    if (!this.dataModel.srcField) {
      alert("请为[" + this.id + "]设置图片路径！");
      return false;
    }
    return true;
  }

  initRuntime() {
    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService 
      || (this.dataModel.dataQuerySetting 
      && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
    )) {
      this.loadData();
    } else {
      if (this._jqObj && this.dataModel.options) {
        this.setImages()
        this.onChangeImages()
      }
    }
  }
}