export default {
  "name": "Steps",
  "comment": "步骤条",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "basicSetting",
      "comment": "基础设置",
      "type": "group",
      "items": [
        {
          "name": "options",
          "comment": "选项设置",
          "type": "Dataset",
          "isPro": true,
          "keyCol": "name",
          "width": "640px",
          "height": "600px",
          "columns": [
            {
              "id": "text",
              "name": "标题",
              "type": "String"
            },
            {
              "id": "describe",
              "name": "描述",
              "type": "String"
            },
            {
              "id": "icon",
              "name": "图标",
              "type": "String"
            },
            {
              "id": "status",
              "name": "状态",
              "type": "Select",
              "default": "notPerformed",
              "options": [
                {
                  "value": "notPerformed",
                  "text": "未进行"
                },
                {
                  "value": "haveInHand",
                  "text": "进行中"
                },
                {
                  "value": "completed",
                  "text": "已完成"
                }
              ]
            },
            {
              "id": "onClick",
              "name": "点击后执行的脚本",
              "type": "Event",
              "width": "180px",
              "wrap": true
            }
          ]
        },
        {
          "name": "alignment",
          "comment": "对齐方式",
          "type": "Select",
          "default": "left",
          "options": [
            {
              "value": "center",
              "text": "居中对齐"
            },
            {
              "value": "left",
              "text": "左对齐"
            }
          ]
        },
        {
          "name": "displayMode",
          "comment": "显示模式",
          "type": "Select",
          "default": "defaultMode",
          "options": [
            {
              "value": "defaultMode",
              "text": "默认模式"
            },
            {
              "value": "introductionMode",
              "text": "简洁模式"
            }
            ,
            {
              "value": "buttonMode",
              "text": "按钮模式"
            }
          ]
        },
        {
          "name": "vertical",
          "comment": "竖式步骤条",
          "type": "Switch"
        },
        {
          "name": "lineStyle",
          "comment": "连接线样式",
          "type": "Switch"
        },
        {
          "name": "displayDescription",
          "comment": "显示步骤描述",
          "type": "Switch",
          "default": true
        },
        {
          "name": "onClickStatus",
          "comment": "点击后改变状态",
          "type": "Switch"
        },
        {
          "name": "backgroundStatus",
          "comment": "背景色随状态改变",
          "type": "Switch"
        },
        {
          "name": "stepsTitleWidth",
          "comment": "步骤标题宽度",
          "type": "Int",
          "default": "70"
        },
        {
          "name": "stepsLineWidth",
          "comment": "步骤连接线宽度",
          "type": "Int",
          "default": "200"
        }
      ]
    },
    {
      "name": "statusSetting",
      "comment": "状态设置",
      "type": "group",
      "items": [
        {
          "name": "notColor",
          "comment": "未进行状态颜色",
          "type": "Color",
          "default": "#c0c4cc"
        },
        {
          "name": "handColor",
          "comment": "进行中状态颜色",
          "type": "Color",
          "default": "#409eff"
        },
        {
          "name": "compColor",
          "comment": "已完成状态颜色",
          "type": "Color",
          "default": "#67c23a"
        }
      ]
    },
    {
      "name": "dataSourceSetting",
      "comment": "数据源设置",
      "type": "group",
      "items": [
        {
          "name": "dataQuerySetting",
          "comment": "数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px"
        },
        {
          "name": "dataListTextFormat",
          "comment": "步骤标题数据格式",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "dataListDescribeFormat",
          "comment": "步骤描述数据格式",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "dataListIconFormat",
          "comment": "步骤图标数据格式",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "dataListStatusFormat",
          "comment": "步骤状态数据格式",
          "type": "String",
          "showModelFieldList": true
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "520px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    },
    {
      "name": "onClickOption",
      "comment": "点击步骤项时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "index",
          "comment": "选项索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "value",
          "comment": "选项值",
          "type": "String",
          "required": true
        }
      ]
    }],
  "methods": [{
    "name": "setStepsProgress",
    "comment": "设置步骤条进度",
    "args": [{
      "name": "index",
      "comment": "选项索引",
      "type": "Int"
    }]
  }]
}