import { FormInput } from "../controller.js";

/**
 * 步骤条组件
 * @param {[type]} dataModel [describe]
 */
export default class Steps extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Steps", dataModel, parent);

    if (!this.dataModel.options) {
      this.dataModel.options = [{
        text: "steps1",
        describe: "describe1",
        status: "haveInHand"
      }, {
        text: "steps2",
        describe: "describe2",
        status: "notPerformed"
      }, {
        text: "steps3",
        describe: "describe3",
        status: "notPerformed"
      }];
    }
  }

  get options() { return this.dataModel.options }
  set options(options) {
    if (this._jqObj && options && Array.isArray(options)) {
      this.dataModel.options = options;
      if (this._jqObj) {
        this.reRender();
      }
    }
  }

  get alignment() { return this.dataModel.alignment }
  set alignment(value) {
    this.dataModel.alignment = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get displayMode() { return this.dataModel.displayMode }
  set displayMode(value) {
    this.dataModel.displayMode = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get vertical() { return this.dataModel.vertical }
  set vertical(value) {
    this.dataModel.vertical = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get lineStyle() { return this.dataModel.lineStyle }
  set lineStyle(value) {
    this.dataModel.lineStyle = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get displayDescription() { return this.dataModel.displayDescription }
  set displayDescription(value) {
    this.dataModel.displayDescription = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get onClickStatus() { return this.dataModel.onClickStatus }
  set onClickStatus(value) {
    this.dataModel.onClickStatus = value ? true : false;
  }

  get backgroundStatus() { return this.dataModel.backgroundStatus }
  set backgroundStatus(value) {
    this.dataModel.backgroundStatus = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get stepsTitleWidth() { return this.dataModel.stepsTitleWidth }
  set stepsTitleWidth(value) {
    this.dataModel.stepsTitleWidth = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get stepsLineWidth() { return this.dataModel.stepsLineWidth }
  set stepsLineWidth(value) {
    this.dataModel.stepsLineWidth = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get notColor() { return this.dataModel.notColor }
  set notColor(value) {
    this.dataModel.notColor = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get handColor() { return this.dataModel.handColor }
  set handColor(value) {
    this.dataModel.handColor = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get compColor() { return this.dataModel.compColor }
  set compColor(value) {
    this.dataModel.compColor = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get loadDataListService() { return this.dataModel.loadDataListService }
  set loadDataListService(value) {
    this.dataModel.loadDataListService = value;
  }

  get dataListBindingMember() { return this.dataModel.dataListBindingMember }
  set dataListBindingMember(value) {
    this.dataModel.dataListBindingMember = value;
  }

  get dataListTextFormat() { return this.dataModel.dataListTextFormat }
  set dataListTextFormat(value) {
    this.dataModel.dataListTextFormat = value;
  }

  get dataListDescribeFormat() { return this.dataModel.dataListDescribeFormat }
  set dataListDescribeFormat(value) {
    this.dataModel.dataListDescribeFormat = value;
  }

  get dataListIconFormat() { return this.dataModel.dataListIconFormat }
  set dataListIconFormat(value) {
    this.dataModel.dataListIconFormat = value;
  }

  get dataListStatusFormat() { return this.dataModel.dataListStatusFormat }
  set dataListStatusFormat(value) {
    this.dataModel.dataListStatusFormat = value;
  }

  reRender() {
    this._jqObj.empty();
    this._jqObj.append(this.getBodyHtml());
    if (!this._tfp.isDesigning) this.bindItemEvent();
  }

  getBodyHtml(getComponentsHtml) {
    let indent = this.getHtmlIndent();
    let html = "\r\n";

    if (this.dataModel.vertical) {
      html += indent + "\t<div class=\"tfp-steps-v\">\r\n";
    } else if (this.dataModel.displayMode == "introductionMode") {
      html += indent + "\t<div class=\"tfp-steps-i\">\r\n";
    } else if (this.dataModel.displayMode == "buttonMode") {
      html += indent + "\t<div class=\"tfp-steps-b\">\r\n";
    } else if (this.dataModel.displayMode == "defaultMode" || this.dataModel.displayMode == "") {
      html += indent + "\t<div class=\"tfp-steps-d\">\r\n";
    }

    for (var i = 0; i < this.dataModel.options.length; i++) {
      let option = this.dataModel.options[i];
      let color = "";
      let borColor = "";
      let bgColor = "";
      let textColor = "";
      let width = "200";
      let textWidth = "70";

      if (!option.describe) option.describe = '';
      if (!option.icon) option.icon = '';
      if (!option.status) option.status = '未进行';

      if (option.status == "notPerformed" || option.status == "未进行" || option.status == 0) {
        color = "color: " + this.dataModel.notColor + ";";
        if (this.dataModel.backgroundStatus) color = "color: #636363;";
        borColor = "border: 2px solid " + this.dataModel.notColor + ";";
        bgColor = "background-color: " + this.dataModel.notColor + ";";
        textColor = "color: " + this.dataModel.notColor + ";";
      } else if (option.status == "haveInHand" || option.status == "进行中" || option.status == 1) {
        color = "color: " + this.dataModel.handColor + ";";
        if (this.dataModel.backgroundStatus) color = "color: #636363;";
        borColor = "border: 2px solid " + this.dataModel.handColor + ";";
        bgColor = "background-color: " + this.dataModel.handColor + ";";
        textColor = "color: " + this.dataModel.handColor + ";";
      } else if (option.status == "completed" || option.status == "已完成" || option.status == 2) {
        color = "color:" + this.dataModel.compColor + ";";
        if (this.dataModel.backgroundStatus) color = "color: #636363;";
        borColor = "border: 2px solid " + this.dataModel.compColor + ";";
        bgColor = "background-color: " + this.dataModel.compColor + ";";
        textColor = "color: " + this.dataModel.compColor + ";";
      }

      if (this.dataModel.stepsLineWidth) width = this.dataModel.stepsLineWidth;
      if (this.dataModel.stepsTitleWidth && this.dataModel.stepsTitleWidth > 70) textWidth = this.dataModel.stepsTitleWidth;

      let iconHtml = "<div class=\"tfp-steps-icon\" style=\"" + color + " " + borColor + "";
      if (this.dataModel.displayMode == "introductionMode" && !this.dataModel.vertical) iconHtml += " background-color: transparent;";
      if (this.dataModel.backgroundStatus) iconHtml += "" + bgColor + "";
      iconHtml += "\">" + parseInt(i + 1) + "</div>";

      if (option.icon) iconHtml = "<img src=\"" + option.icon + "\" style=\"width: 24px; height: 24px;\">"

      let topStyle = "";
      let bottomStyle = "";
      let buttonStyle = "";
      let lineStyle = "";

      if (this.dataModel.alignment == 'center') {
        topStyle = "left: calc(50% - 12px);";
        bottomStyle = "text-align: center;";
        buttonStyle = "margin-left: calc(50% - " + textWidth / 2 + "px);";
        lineStyle = "right: " + width / 2 + "px;";
      } else {
        topStyle = "left: 0;";
        bottomStyle = "text-align: left;";
        buttonStyle = "margin-left: 0;";
        lineStyle = "right: " + width + "px;";
      }

      if (this.dataModel.vertical) {
        html += indent + "\t<div class=\"tfp-steps-item-v\" style=\"height:" + width + "px;\">\r\n";
        html += indent + "\t<div class=\"tfp-steps-left-v\">\r\n";
        html += indent + "\t<div class=\"tfp-steps-line-v\" style=\"";
        if (this.dataModel.lineStyle) {
          html += "top:calc(-" + width / 2 + "px + 12px);height:10px;background-color:#636363;";
        } else {
          html += "" + bgColor + "top:calc(-" + width + "px + 12px);";
        }
        html += "\">"
        if (this.dataModel.lineStyle) html += "<div class=\"tfp-steps-arrow-down\"></div>"
        html += "</div>\r\n";
        html += indent + "\t<div>" + iconHtml + "</div>\r\n";
        html += indent + "\t</div>\r\n";
        html += indent + "\t<div class=\"tfp-steps-right-v\" style=\"" + bottomStyle + "\">\r\n";

        html += indent + "\t<div class=\"tfp-steps-text\" style=\"" + textColor + "\"";
        if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
        html += ">" + option.text + "</div>\r\n";

        if (this.dataModel.displayDescription) html += indent + "\t<div class=\"tfp-steps-describe\">" + option.describe + "</div>\r\n";

        html += indent + "\t</div>\r\n";
        html += indent + "\t</div>\r\n";
      } else if (this.dataModel.displayMode == "introductionMode") {
        html += indent + "\t<div class=\"tfp-steps-item-i\" style=\"width:" + width + "px;\">\r\n";
        html += indent + "\t<div>" + iconHtml + "</div>\r\n";
        html += indent + "\t<div class=\"tfp-steps-center-i\" style=\"width:calc(" + width + "px - 40px)\">\r\n";

        html += indent + "\t<div class=\"tfp-steps-text-i\" style=\"" + textColor + "\"";
        if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
        html += ">" + option.text + "</div>\r\n";

        if (this.dataModel.displayDescription) html += indent + "\t<div class=\"tfp-steps-describe\">" + option.describe + "</div>\r\n";

        html += indent + "\t</div>\r\n";
        html += indent + "\t<div class=\"tfp-steps-line-i\"></div>\r\n";
        html += indent + "\t</div>\r\n";
      } else if (this.dataModel.displayMode == "buttonMode") {
        html += indent + "\t<div class=\"tfp-steps-item-b\" style=\"width:" + (parseInt(width) + parseInt(textWidth)) + "px;\">\r\n";
        html += indent + "\t<div class=\"tfp-steps-top-b\">\r\n";

        html += indent + "\t<div class=\"tfp-steps-button-b\" style=\"" + color + " " + borColor + " " + buttonStyle + "width:" + textWidth + "px;";
        if (this.dataModel.backgroundStatus) html += "" + bgColor + "";
        html += "\"";
        if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
        html += ">" + option.text + "</div>\r\n";

        html += indent + "\t<div class=\"tfp-steps-line-b\" style=\"";
        if (this.dataModel.lineStyle) {
          let lineWidth = "";
          if (this.dataModel.alignment == 'center') {
            lineWidth = parseInt(width) + parseInt(textWidth);
          } else {
            lineWidth = parseInt(width) + parseInt(width / 2) + parseInt(textWidth);
          }
          html += "width:10px;right: " + lineWidth + "px;background-color:#636363;";
        } else {
          html += "" + lineStyle + "" + bgColor + "";
        }
        html += "\">"
        if (this.dataModel.lineStyle) html += "<div class=\"tfp-steps-arrow-right\"></div>"
        html += "</div>\r\n";
        html += indent + "\t</div>\r\n";
        html += indent + "\t<div class=\"tfp-steps-bottom-b\" style=\"" + bottomStyle + "\">\r\n";

        if (this.dataModel.displayDescription) html += indent + "\t<div class=\"tfp-steps-describe\">" + option.describe + "</div>\r\n";

        html += indent + "\t</div>\r\n";
        html += indent + "\t</div>\r\n";
      } else {
        html += indent + "\t<div class=\"tfp-steps-item\" style=\"width:" + width + "px;\">\r\n";
        html += indent + "\t<div class=\"tfp-steps-top\" style=\"" + topStyle + "\">\r\n";
        html += indent + "\t<div class=\"tfp-steps-line\" style=\"";
        if (this.dataModel.lineStyle) {
          let lineWidth = parseInt(width / 2) + parseInt(width);
          html += "right:calc(" + lineWidth + "px - 12px);width:10px;background-color:#636363;";
        } else {
          html += "" + bgColor + "right:calc(" + width + "px - 12px);";
        }
        html += "\">"
        if (this.dataModel.lineStyle) html += "<div class=\"tfp-steps-arrow-right\"></div>"
        html += "</div>\r\n";
        html += indent + "\t<div>" + iconHtml + "</div>\r\n";
        html += indent + "\t</div>\r\n";
        html += indent + "\t<div class=\"tfp-steps-bottom\" style=\"" + bottomStyle + "\">\r\n";

        html += indent + "\t<div class=\"tfp-steps-text\" style=\"" + textColor + "\"";
        if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
        html += ">" + option.text + "</div>\r\n";

        if (this.dataModel.displayDescription) html += indent + "\t<div class=\"tfp-steps-describe\">" + option.describe + "</div>\r\n";

        html += indent + "\t</div>\r\n";
        html += indent + "\t</div>\r\n";
      }
    }

    html += indent + "\t</div>\r\n";

    return html + "\t";
  }

  /**
   * 检查数据加载参数是否设置正确
   * @returns 
   */
  checkLoadDataArg() {
    if (!this.dataModel.dataListTextFormat) {
      alert("请为[" + this.id + "]设置步骤标题数据格式！");
      return false;
    }
    return true;
  }

  bindData(data) {
    if (isNull(data) || !Array.isArray(data)) return;
    let options = [];
    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {};
      try {
        let titleFormat = "text";
        if (this.dataModel.dataListTextFormat) titleFormat = this.dataModel.dataListTextFormat;
        if (titleFormat.indexOf("{") < 0 && titleFormat.indexOf("#[") < 0) titleFormat = "{" + titleFormat + "}";
        option.text = this._tfp.replaceDataField(row, titleFormat);
        if (option.text) option.text = this._tfp.exeExpress(option.text);
      } catch (e) {
        console.log(e);
        return;
      }
      if (isNull(option.text)) continue;
      try {
        let describeFormat = "describe";
        if (this.dataModel.dataListDescribeFormat) describeFormat = this.dataModel.dataListDescribeFormat;
        if (describeFormat.indexOf("{") < 0 && describeFormat.indexOf("#[") < 0) describeFormat = "{" + describeFormat + "}";
        option.describe = this._tfp.replaceDataField(row, describeFormat);
        if (option.describe) option.describe = this._tfp.exeExpress(option.describe);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let iconFormat = "icon";
        if (this.dataModel.dataListIconFormat) iconFormat = this.dataModel.dataListIconFormat;
        if (iconFormat.indexOf("{") < 0 && iconFormat.indexOf("#[") < 0) iconFormat = "{" + iconFormat + "}";
        option.icon = this._tfp.replaceDataField(row, iconFormat);
        if (option.icon) option.icon = this._tfp.exeExpress(option.icon);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let statusFormat = "status";
        if (this.dataModel.dataListStatusFormat) statusFormat = this.dataModel.dataListStatusFormat;
        if (statusFormat.indexOf("{") < 0 && statusFormat.indexOf("#[") < 0) statusFormat = "{" + statusFormat + "}";
        option.status = this._tfp.replaceDataField(row, statusFormat);
        if (option.status) option.status = this._tfp.exeExpress(option.status);
      } catch (e) {
        console.log(e);
        return;
      }
      options.push(option);
    }
    this.options = options;
  }

  bindItemEvent() {
    var that = this;
    this._jqObj.find(".tfp-steps-text").click(function () {
      if (that.dataModel.onClickStatus) that.setColor(this);
      var index = $(this).parent().parent().index();
      var option = that.options[index];
      var value = option.text;
      that.dataModel.value = value;
      that.valueOnChange();
      that.exeEventHandler("onChange", value);

      try {
        if (option.onClick) eval(option.onClick);
        if (that.dataModel.onClickOption) eval(that.dataModel.onClickOption);
      } catch (err) {
        console.log(err.message);
      }
    })

    this._jqObj.find(".tfp-steps-text-i").click(function () {
      if (that.dataModel.onClickStatus) that.setColor(this);
      var index = $(this).parent().index();
      var option = that.options[index];
      var value = option.text;
      that.dataModel.value = value;
      that.valueOnChange();
      that.exeEventHandler("onChange", value);

      try {
        if (option.onClick) eval(option.onClick);
        if (that.dataModel.onClickOption) eval(that.dataModel.onClickOption);
      } catch (err) {
        console.log(err.message);
      }
    })

    this._jqObj.find(".tfp-steps-button-b").click(function () {
      if (that.dataModel.onClickStatus) that.setColor(this);
      var index = $(this).parent().index();
      var option = that.options[index];
      var value = option.text;
      that.dataModel.value = value;
      that.valueOnChange();
      that.exeEventHandler("onChange", value);

      try {
        if (option.onClick) eval(option.onClick);
        if (that.dataModel.onClickOption) eval(that.dataModel.onClickOption);
      } catch (err) {
        console.log(err.message);
      }
    })
  }

  setStepsProgress(index) {
    if (this.dataModel.displayMode == "introductionMode") {
      this.setColor(this._jqObj.find(".tfp-steps-text-i").eq(index));
    } else if (this.dataModel.displayMode == "buttonMode") {
      this.setColor(this._jqObj.find(".tfp-steps-button-b").eq(index));
    } else {
      this.setColor(this._jqObj.find(".tfp-steps-text").eq(index));
    }
  }

  setColor(el) {
    var notColor = "#c0c4cc";
    var handColor = "#409eff";
    var compColor = "#67c23a";
    if (this.dataModel.notColor) notColor = this.dataModel.notColor;
    if (this.dataModel.handColor) handColor = this.dataModel.handColor;
    if (this.dataModel.compColor) compColor = this.dataModel.compColor;

    var notColorCss = {};
    var handColorCss = {};
    var compColorCss = {};
    if (this.dataModel.backgroundStatus) {
      handColorCss = {
        "color": "#636363",
        "border": "2px solid" + handColor + "",
        "background-color": "" + handColor + ""
      };
      compColorCss = {
        "color": "#636363",
        "border": "2px solid" + compColor + "",
        "background-color": "" + compColor + ""
      };
      notColorCss = {
        "color": "#636363",
        "border": "2px solid" + notColor + "",
        "background-color": "" + notColor + ""
      };
    } else {
      handColorCss = {
        "color": handColor,
        "border": "2px solid" + handColor + ""
      };
      compColorCss = {
        "color": compColor,
        "border": "2px solid" + compColor + ""
      };
      notColorCss = {
        "color": notColor,
        "border": "2px solid" + notColor + ""
      };
    }

    $(el).css("color", handColor);

    // 默认模式
    $(el).parent().parent().prevAll().find('.tfp-steps-text').css("color", compColor);
    $(el).parent().parent().nextAll().find('.tfp-steps-text').css("color", notColor);
    if (!this.dataModel.lineStyle) {
      $(el).parent().siblings('.tfp-steps-top').find('.tfp-steps-line').css("backgroundColor", handColor);
      $(el).parent().parent().prevAll().find('.tfp-steps-line').css("backgroundColor", compColor);
      $(el).parent().parent().nextAll().find('.tfp-steps-line').css("backgroundColor", notColor);
    }
    $(el).parent().siblings('.tfp-steps-top').find('.tfp-steps-icon').css(handColorCss);
    $(el).parent().parent().prevAll().find('.tfp-steps-icon').css(compColorCss);
    $(el).parent().parent().nextAll().find('.tfp-steps-icon').css(notColorCss);

    // 简洁模式
    $(el).parent().parent().prevAll().find('.tfp-steps-text-i').css("color", compColor);
    $(el).parent().parent().nextAll().find('.tfp-steps-text-i').css("color", notColor);
    $(el).parent().siblings().find('.tfp-steps-icon').css(handColorCss);
    $(el).parent().parent().prevAll().find('.tfp-steps-icon').css(compColorCss);
    $(el).parent().parent().nextAll().find('.tfp-steps-icon').css(notColorCss);

    // 按钮模式
    if (!this.dataModel.lineStyle) {
      $(el).siblings('.tfp-steps-line-b').css("backgroundColor", handColor);
      $(el).parent().parent().prevAll().find('.tfp-steps-line-b').css("backgroundColor", compColor);
      $(el).parent().parent().nextAll().find('.tfp-steps-line-b').css("backgroundColor", notColor);
    }
    $(el).parent().find('.tfp-steps-button-b').css(handColorCss);
    $(el).parent().parent().prevAll().find('.tfp-steps-button-b').css(compColorCss);
    $(el).parent().parent().nextAll().find('.tfp-steps-button-b').css(notColorCss);

    // 竖式步骤条
    if (!this.dataModel.lineStyle) {
      $(el).parent().siblings('.tfp-steps-left-v').find('.tfp-steps-line-v').css("backgroundColor", handColor);
      $(el).parent().parent().prevAll().find('.tfp-steps-line-v').css("backgroundColor", compColor);
      $(el).parent().parent().nextAll().find('.tfp-steps-line-v').css("backgroundColor", notColor);
    }
    $(el).parent().siblings('.tfp-steps-left-v').find('.tfp-steps-icon').css(handColorCss);
  }

  initRuntime() {
    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService
      || (this.dataModel.dataQuerySetting
        && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
      )) {
      this.loadData();
    }
    this.reRender();
  }
}