import TFPComponentRender from "../render.js";
export default class SliderRender extends TFPComponentRender {
  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }
  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "";
    let indent = this.getHtmlIndent();
    let val = 0;
    if(this.dataModel.value){
      val = this.dataModel.value
    }
    bodyHtml += `<div class="tfp-slider__runway">
                    <div class="tfp-slider__bar" style="width: ${val}%; left: 0%;"></div>
                    <div tabindex="0" class="tfp-slider__button-wrapper" style="left:  ${val}%;">
                      <div class="tfp-slider__button" tabindex="0"></div>
                      <div class="tfp-tooltip" tabindex="0">${val}</div>
                    </div>
                </div>`;
    return bodyHtml;
  }

  getAttrHtml() {
    var attrHtml = super.getAttrHtml();
    attrHtml += ' type="slider"';
    // if(this._tfp.isDesigning && attrHtml.indexOf("readonly")<0)
    //   attrHtml += " readonly";
    return attrHtml;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    var html = super.getHtml("div", false, parentIndent, retainStyleAttr);
    return html;
  }
}
