import { FormInput } from "../controller.js";

/**
 * 滑块组件
 * @param {[type]} dataModel [description]
 */
export default class Slider extends FormInput {
  constructor(__tfp, dataModel, parent, inputType) {
    if (inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "Slider", dataModel, parent);
    }
  }

  get value() {
    return this.dataModel.value || 0;
  }
  set value(value) {
    let val = value;
    if (isNull(value)) {
      val = 0;
    }
    this.dataModel.value = val;
    if (this._jqObj) {
      var dragBox = this._jqObj.find('.tfp-slider__button-wrapper');
      dragBox.css('left', val + "%")
      this._jqObj.find('.tfp-slider__bar').width(val + "%");
      this._jqObj.find('.tfp-tooltip').text(val);
    }
  }

  get dataType() {
    if (!this.dataModel.dataType) this.dataModel.dataType = "text";
    return this.dataModel.dataType;
  }
  set dataType(value) {
    this.dataModel.dataType = value;
  }

  initRuntime() {
    let that = this;
    if (this.dataModel.readonly || this.dataModel.disabled) return;
    this._jqObj.mousedown(onMousedown.bind(this));

    function onMousedown() {
      var self = this;
      var event = event || window.event;
      var drag = event.target;

      if (drag.classList.contains('tfp-slider__button')) {
        drag = drag.parentNode;
      }
      if (!drag.classList.contains('tfp-slider__button-wrapper')) return
      var boxWidth = $(drag).parent().outerWidth();
      var diffX = event.clientX - drag.offsetLeft;
      var diffY = event.clientY - drag.offsetTop;
      if (typeof drag.setCapture !== "undefined") {
        drag.setCapture();
      }
      var percent = '';
      document.onmousemove = function (event) {
        var event = event || window.event;
        var moveX = event.clientX - diffX;
        if (moveX < 0) {
          moveX = 0;
        } else if (moveX > window.innerWidth - drag.offsetWidth) {
          moveX = window.innerWidth - drag.offsetWidth;
        }
        if (moveX < 0 || moveX > boxWidth) return
        percent = Math.round(moveX / boxWidth * 100);
        self.value = percent;
      };
      document.onmouseup = function (event) {
        this.onmousemove = null;
        this.onmouseup = null;
        //修复低版本ie bug
        if (typeof drag.releaseCapture != "undefined") {
          drag.releaseCapture();
        }
        if (!that._tfp.isDesigning) {
          that.valueOnChange();
          that.exeEventHandler("onChange", percent);
        }
      };
    }
  }
}
