import TFPComponentRender from '../render.js'

export default class SignaturesRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml() {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    html += indent + "\t<canvas class=\"tfp-signatures-canvas\"></canvas>";
    html += "\r\n";
    let display = "";
    if(this.dataModel.disabled || this.dataModel.readonly) {
      display = " style=\"display:none;\"";
    }
    html += indent + "\t<button class=\"tfp-signatures-clear\""+display+">清除</button>"
      +"<button class=\"tfp-signatures-save\""+display+">确定</button>"
    html += "\r\n";
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}