import { FormInput } from "../controller.js";

/**
 * 签名组件
 * @param {[type]} dataModel [description]
 */
export default class Signatures extends FormInput {

  constructor(__tfp, dataModel, parent, inputType) {
    if (inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "Signatures", dataModel, parent);
    }
  }

  get value() { return this.dataModel.value ? this.dataModel.value : ""; }
  set value(value) {
    if (value) {
      this.dataModel.value = value
      if (this._jqObj) {
        const canvas = this._jqObj.find(".tfp-signatures-canvas")[0];
        const context = canvas.getContext('2d');
        canvas.width = this._jqObj.width(); // 设置宽度
        canvas.height = this._jqObj.height() - 40; // 设置高度

        var img = new Image();
        img.src = "" + this.dataModel.value + "";
        img.onload = () => {
          context.drawImage(img, 0, 0, this._jqObj.width(), this._jqObj.height() - 40);
        }
      }
    } else {
      this.dataModel.value = "";
    }
  }

  css(styleName, styleValue) {
    if (arguments.length == 0) return;
    //获取样式值
    if (arguments.length == 1) {
      if (!this.dataModel.styles) return null;
      return this.dataModel.styles[styleName];
    }
    if (this._jqObj) this._jqObj.css(styleName, styleValue);
    if (!this.dataModel.styles) this.dataModel.styles = {};
    if (styleValue == "" || styleValue == null) {
      delete this.dataModel.styles[styleName];
    } else {
      this.dataModel.styles[styleName] = styleValue;
      if (styleName == 'width' || styleName == 'height') this.initRuntime();
    }
  }

  initRuntime() {
    var that = this;
    const canvas = this._jqObj.find(".tfp-signatures-canvas")[0];
    const context = canvas.getContext('2d');
    canvas.width = this._jqObj.width(); // 设置宽度
    canvas.height = this._jqObj.height() - 40; // 设置高度

    if (this.dataModel.value) {
      var img = new Image();
      img.src = "" + this.dataModel.value + "";
      img.onload = () => {
        context.drawImage(img, 0, 0, this._jqObj.width(), this._jqObj.height() - 40);
      }
    }

    if (this.dataModel.disabled) return;

    let isDrawing = false;
    let lastX = 0;
    let lastY = 0;

    canvas.addEventListener('touchstart', startDrawing);
    if (this.dataModel.readonly) return;
    canvas.addEventListener('touchmove', draw);
    canvas.addEventListener('touchend', stopDrawing);
    
    function startDrawing(e) {
      try {
        if (that.dataModel.onClick) eval(that.dataModel.onClick);
      } catch (err) {
        console.log(err.message);
      }
      if (that.dataModel.readonly) return;
      const touch = e.touches[0];
      isDrawing = true;
      const { left, top } = canvas.getBoundingClientRect(); // 获取Canvas相对于窗口的偏移
      [lastX, lastY] = [touch.clientX - left, touch.clientY - top];
    }

    function draw(e) {
      if (!isDrawing) return;
      e.preventDefault();
      const touch = e.touches[0];
      const { left, top } = canvas.getBoundingClientRect(); // 获取Canvas相对于窗口的偏移
      const offsetX = touch.clientX - left;
      const offsetY = touch.clientY - top;

      // 检查触摸是否在自定义范围内
      if (offsetX >= 0 && offsetX < canvas.width && offsetY >= 0 && offsetY < canvas.height) {
        context.beginPath();
        context.moveTo(lastX, lastY);
        context.lineTo(offsetX, offsetY);
        context.stroke();
        [lastX, lastY] = [offsetX, offsetY];
      }
    }

    function stopDrawing() {
      that.valueOnChange();
      that.exeEventHandler("onChange", that.dataModel.value);
      isDrawing = false;
      var dataURL = canvas.toDataURL();
      that.dataModel.value = dataURL;
    }

    this.mask = true;
    this._jqObj.find(".tfp-signatures-clear").bind("click", function () {
      context.clearRect(0, 0, canvas.width, canvas.height);
      that.dataModel.value = "";
      that._jqObj.find("div").eq(0).remove();
      that.mask = true;
    });

    this._jqObj.find(".tfp-signatures-save").bind("click", function () {
      if (that.mask) {
        that._jqObj.prepend("<div style='width:100%;height:calc(100% - 40px);position:absolute;'></div>");
        that.mask = false;
      }
    });
  }
}