import TFPComponentRender from '../render.js'

export default class SignRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }


  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    var signType = "name";
    if (this.dataModel.signType == "sign") signType = "sign";
    bodyHtml += '<div class="tfp-sign-div">';
    if (this._tfp.isDesigning) {
      if (this.dataModel.signType == "sign") {
        bodyHtml += '<img src="' + this._tfp.rootPath + '/src/components/sign/images/example.png" />'
      }
      else {
        bodyHtml += '<span style="height:30px;">签字</span>';
      }
    }
    bodyHtml += '</div>';

    bodyHtml += '<div class="tfp-sign-button">签章</div>';
    return bodyHtml + indent;
  }

  getAttrClass() {
    let c = "";
    if (this.dataModel.horizontal) c += "tfp-sign-horizontal";
    return c;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}