import { FormInput } from "../controller.js";

/**
 * 签章组件
 * @param {[type]} dataModel [description]
 */
export default class Sign extends FormInput {
  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Sign", dataModel, parent);
  }

  get value() { return this.dataModel.value ? this.dataModel.value : "" }
  set value(value) {
    let vs; //user_id,user_name,sign_code
    var val = null;
    if (this._tfp.isNull(value)) {
      value = null;
      this.dataModel.value = null;
    }
    else {
      try {
        if (typeof (value) == "string") {
          value = JSON.parse(value);
        }
      } catch (e) {
        if (value != '') {
          vs = value.split(',');
        }
      }

      if (this.dataModel.valueType == "obj") {
        if (typeof (value) == "string") {
          if (vs.length > 2) this.dataModel.value = { "id": vs[0], "name": vs[1], "sign_code": vs[2] };
          else if (vs.length > 1) this.dataModel.value = { "id": vs[0], "name": vs[1] };
          else this.dataModel.value = { "id": vs[0], "name": vs[0] };
        }
        else {
          this.dataModel.value = value;
        }
        val = this.dataModel.value;
      }
      else {
        if (typeof (value) == "string") {
          this.dataModel.value = value;

          if (vs.length > 2) val = { "id": vs[0], "name": vs[1], "sign_code": vs[2] };
          else if (vs.length > 1) val = { "id": vs[0], "name": vs[1] };
          else val = { "id": vs[0], "name": vs[0] };
        }
        else {
          if (value.sign_code)
            this.dataModel.value = value.id + "," + value.name + "," + value.sign_code;
          else
            this.dataModel.value = value.id + "," + value.name;

          val = value;
        }
      }

      if (this._jqObj) {
        if (!this._tfp.isDesigning) {
          if (val) {
            if (val.sign_code) {
              this._jqObj.find(".tfp-sign-div").html('<img src="/Download?fileCode=' + val.sign_code + '" style="width:160px;height:80px;" />');
            }
            else {
              this._jqObj.find(".tfp-sign-div").html('<span style="height:30px;">' + val.name + '</span>');
            }

            this._jqObj.find(".tfp-sign-div").show();
            this._jqObj.find(".tfp-sign-button").html('撤销签章');
            if (tfp.curUser.id != val.id) {
              this._jqObj.find(".tfp-sign-button").hide();
            }
          }
          else {
            this._jqObj.find(".tfp-sign-div").empty();
            this._jqObj.find(".tfp-sign-button").html('签章');
            this._jqObj.find(".tfp-sign-div").hide();
          }
        }

      }
    }
  }

  get valueType() { return this.dataModel.valueType }
  set valueType(value) {
    this.dataModel.valueType = value;
  }

  get signType() { return this.dataModel.signType }
  set signType(value) {
    this.dataModel.signType = value;

    if (this._jqObj) {
      if (this._tfp.isDesigning) {
        if (this.dataModel.signType == "sign") {
          this._jqObj.find(".tfp-sign-div").html('<img src="' + this._tfp.rootPath + '/src/components/sign/images/example.png" style="width:160px;height:80px;" />');
        }
        else {
          this._jqObj.find(".tfp-sign-div").html('<span style="height:30px;">签字</span>');
        }
      }
    }
  }

  get isInputPassword() { return this.dataModel.isInputPassword }
  set isInputPassword(value) {
    this.dataModel.isInputPassword = value ? true : false;
  }

  get horizontal() { return this.dataModel.horizontal }
  set horizontal(value) {
    this.dataModel.horizontal = value ? true : false;
    if (this._jqObj) {
      this._jqObj.removeClass("tfp-sign-horizontal");
      if (value) {
        this._jqObj.addClass("tfp-sign-horizontal");
      }
    }
  }

  /**
   * 确定签章
   */
  confirmSign() {
    var signHtml = "";
    if (this.dataModel.signType == "sign") {
      if (tfp.curSign.sign_code) {
        signHtml = '<img src="/Download?fileCode=' + tfp.curSign.sign_code + '" style="width:160px;height:80px;"></img>';
        if (this.dataModel.valueType == "obj") {
          this.dataModel.value = { "id": tfp.curSign.user_id, "name": tfp.curSign.user_name, "sign_code": tfp.curSign.sign_code };
        }
        else {
          this.dataModel.value = tfp.curSign.user_id + "," + tfp.curSign.user_name + "," + tfp.curSign.sign_code;
        }
      }
      else {
        signHtml = '<span style="height:30px;">' + tfp.curSign.user_name + '</span>';
        if (this.dataModel.valueType == "obj") {
          this.dataModel.value = { "id": tfp.curSign.user_id, "name": tfp.curSign.user_name };
        }
        else {
          this.dataModel.value = tfp.curSign.user_id + "," + tfp.curSign.user_name;
        }
      }
    }
    else {
      signHtml = '<span style="height:30px;">' + tfp.curSign.user_name + '</span>';
      if (this.dataModel.valueType == "obj") {
        this.dataModel.value = { "id": tfp.curSign.user_id, "name": tfp.curSign.user_name };
      }
      else {
        this.dataModel.value = tfp.curSign.user_id + "," + tfp.curSign.user_name;
      }
    }

    this._jqObj.find(".tfp-sign-div").empty().append(signHtml);
    this._jqObj.find(".tfp-sign-button").html('撤销签章');
    this._jqObj.find(".tfp-sign-div").show();
  }

  /**
   * 取消签章
   */
  cancelSign() {
    this.dataModel.value = null;

    this._jqObj.find(".tfp-sign-div").empty();
    this._jqObj.find(".tfp-sign-button").html('签章');
    this._jqObj.find(".tfp-sign-div").hide();
  }

  /**
   * 获取签章信息
   * @param {*} cb 
   */
  getSignCode(cb) {
    if (!tfp.curSign) {
      tfp.use(["Service"], function () {
        var service = tfp["new"]("Service");
        service.path = "sys/service/sign/getInfo.js";
        service.request(null, function (req, res) {
          tfp.curSign = res.curSign;
          if (cb) cb();
        });
      });
    }
    else {
      if (cb) cb();
    }
  }


  initRuntime() {
    let that = this;

    that._jqObj.find(".tfp-sign-button").click(function () {
      if (that.dataModel.readonly || that.dataModel.disabled) return;
      var s = that._jqObj.find(".tfp-sign-button").text();
      if (s == "签章") {
        if (that.dataModel.isInputPassword) {
          that._tfp.openDialog("输入签章密码", that._tfp.rootPath + "/src/components/sign/signPicker.tfp", "350px", "160px", null, function (ret) {
            tfp.curSign = ret.curSign;
            that.confirmSign();
          });
        }
        else {
          that.getSignCode(function () {
            that.confirmSign();
          });
        }
      }
      else {
        var tmpid;
        if (!that._tfp.isNull(that.dataModel.value)) {
          if (typeof (that.dataModel.value) == "string") {
            tmpid = that.dataModel.value.split(',')[0];
          }
          else {
            tmpid = that.dataModel.value.id;
          }
        }

        if (tmpid != that._tfp.curSign.user_id) {
          alert("不是本人签章，不能撤销！");
        }
        else {
          if (that.dataModel.isInputPassword) {
            that._tfp.openDialog("输入签章密码", that._tfp.rootPath + "/src/components/sign/signPicker.tfp", "350px", "160px", null, function (ret) {
              that.cancelSign();
            });
          }
          else {
            that.cancelSign();
          }
        }
      }
    });
  }
}