import TFPComponentRender from '../render.js'

export default class ShareRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    html += indent;
    if(!this.dataModel.value){
      this.dataModel.value = ''
    }
    html += `<button><view class="wx-share-icon"></view></button>`;
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", false, parentIndent, retainStyleAttr, otherOptions);
  }
}