import { FormInput } from "../controller.js";

/**
 * 分享组件
 * @param {[type]} dataModel [description]
 */
export default class Share extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Share", dataModel, parent);
  }
  // url地址
  set url(value) {
    this.dataModel.url = value;
  }
  get url() {
    return this.dataModel.url;
  }
  // 分享标题
  set title(value) {
    this.dataModel.title = value;
  }
  get title() {
    return this.dataModel.title;
  }
  // 分享内容
  set content(value) {
    this.dataModel.content = value;
  }
  get content() {
    return this.dataModel.content;
  }
  // 分享图片url地址
  set imageUrl(value) {
    this.dataModel.imageUrl = value;
  }
  get imageUrl() {
    return this.dataModel.imageUrl;
  }

  // 初始化 运行时   页面渲染完成执行
  initRuntime() {
    var that = this;
    this._jqObj.click(function () {
      if (!that._tfp.isDesigning) {
        if (window.tmClient) {
          if (window.tmClient.mobileType == 'dingding') {
            window.tmClient.empower(function () {
              window.tmClient.share({
                url: that.dataModel.url,
                title: that.dataModel.title,
                content: that.dataModel.content,
                imageUrl: that.dataModel.imageUrl
              }, function () {
              });
            })
          } else if (window.tmClient.mobileType == 'workwx') {
            window.tmClient.empower(function () {
              window.tmClient.share({
                url: that.dataModel.url,
                title: that.dataModel.title,
                content: that.dataModel.content,
                imageUrl: that.dataModel.imageUrl
              }, function () {
              });
            })
          }
        }
      }
    })
  }
}