export default {
  "name": "Service",
  "comment": "服务请求",
  "attrs": [
    {
      "name": "path",
      "comment": "服务路径",
      "type": "ServicePicker"
    },
    {
      "name": "argSettings",
      "comment": "请求参数",
      "type": "Dataset",
      "columns": [
        {
          "id": "name",
          "name": "参数名",
          "type": "String",
          "required": true,
          "width": "140px"
        },
        {
          "id": "type",
          "name": "参数类型",
          "type": "Select",
          "width": "100px",
          "options": [
            {
              "value": "Default",
              "text": "默认"
            },
            {
              "value": "ComponentVal",
              "text": "组件值"
            },
            {
              "value": "ComponentAttr",
              "text": "组件属性"
            },
            {
              "value": "QueryString",
              "text": "URL参数"
            },
            {
              "value": "DialogArg",
              "text": "对话框参数"
            },
            {
              "value": "DrawerArg",
              "text": "抽屉页参数"
            },
            {
              "value": "Expression",
              "text": "表达式"
            }
          ]
        },
        {
          "id": "value",
          "name": "参数值",
          "type": "String",
          "width": "150px"
        },
        {
          "id": "autoReload",
          "name": "自动重载",
          "type": "Switch",
          "width": "65px"
        },
        {
          "id": "encrypt",
          "name": "加密传输",
          "type": "Switch",
          "width": "65px"
        }
      ]
    },
    {
      "name": "autoReload",
      "comment": "参数变化时自动重载",
      "type": "Switch"
    },
    {
      "name": "autoShowError",
      "comment": "自动显示错误提示",
      "type": "Switch",
      "default": true
    },
    {
      "name": "showLoading",
      "comment": "是否显示加载动画",
      "type": "Switch"
    },
    {
      "name": "encryptRequestArgs",
      "comment": "加密请求参数",
      "type": "String",
    },
    {
      "name": "encryptResponseArgs",
      "comment": "加密响应参数",
      "type": "String",
    }
  ],
  "events": [{
    "name": "onRequest",
    "comment": "请求服务时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "args",
      "type": "Object",
      "comment": "请求参数"
    }]
  }, {
    "name": "onResponse",
    "comment": "服务响应时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "req",
      "type": "Object",
      "comment": "请求参数"
    }, {
      "name": "res",
      "type": "Object",
      "comment": "响应参数"
    }]
  }, {
    "name": "onError",
    "comment": "发生错误时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "msg",
      "type": "String",
      "comment": "错误消息"
    }]
  }],
  "methods": [
    {
      "name": "request",
      "comment": "发送请求",
      "haveCbFunc": true,
      "args": [
        {
          "name": "args",
          "comment": "请求参数",
          "type": "Object"
        }
      ],
      "cbArgs": [
        {
          "name": "req",
          "comment": "请求对象",
          "type": "Object"
        },
        {
          "name": "res",
          "comment": "响应对象",
          "type": "Object"
        }
      ]
    },
    {
      "name": "setArg",
      "comment": "设置请求参数",
      "args": [
        {
          "name": "name",
          "comment": "参数名称",
          "type": "String",
          "required": true
        },
        {
          "name": "value",
          "comment": "参数值",
          "type": "String",
          "required": true
        }
      ]
    },
    {
      "name": "setArgSetting",
      "comment": "设置请求参数列表里的参数",
      "args": [
        {
          "name": "name",
          "comment": "参数名称",
          "type": "String",
          "required": true
        },
        {
          "name": "type",
          "comment": "参数类型",
          "type": "Select",
          "default": "Default",
          "options": [
            {
              "value": "Default",
              "text": "默认"
            },
            {
              "value": "ComponentVal",
              "text": "组件值"
            },
            {
              "value": "ComponentAttr",
              "text": "组件属性"
            },
            {
              "value": "QueryString",
              "text": "URL参数"
            },
            {
              "value": "DialogArg",
              "text": "对话框参数"
            },
            {
              "value": "Expression",
              "text": "表达式"
            }
          ]
        },
        {
          "name": "value",
          "comment": "参数值",
          "type": "String",
          "required": true
        }
      ]
    },
    {
      "name": "removeArgSetting",
      "comment": "删除请求参数列表里的参数",
      "args": [
        {
          "name": "name",
          "comment": "参数名称",
          "type": "String",
          "required": true
        }
      ]
    }
  ]
}