import TFPComponentRender from '../render.js'

export default class SelectRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let indent = this.getHtmlIndent();
    if (this._tfp.isDesigning) {
      return indent + "\t<img src=\"" + this._tfp.rootPath + "/src/components/select/images/arrow-down-"
        + this._tfp.curPage.contentColorMode + ".png\" />\r\n";
    }
    else {
      if (this.dataModel.jsonDataSet) {
        this.dataModel.options = this.dataModel.jsonDataSet.options;
      }

      if (this.dataModel.options) {
        let html = "";
        if (this.dataModel.readonly) {
          for (var i = 0; i < this.dataModel.options.length; i++) {
            let option = this.dataModel.options[i];
            if ((option.value + "") == (this.dataModel.value + "")) {
              html += indent + "\t<option value=\"" + option.value + "\" selected>"
                + (option.text ? option.text : option.value) + "</option>\r\n";
            }
          }
        } else {
          html += "\r\n";
          if (this._tfp.isNull(this.dataModel.value) || !this.dataModel.required) 
            html += indent + "\t<option value=\"\"></option>\r\n";
          for (var i = 0; i < this.dataModel.options.length; i++) {
            let option = this.dataModel.options[i];
            html += indent + "\t<option value=\"" + option.value + "\"";
            if ((option.value + "") == (this.dataModel.value + "")) html += " selected";
            html += ">" + (option.text ? option.text : option.value) + "</option>\r\n";
          }
          html += indent;
        }
        return html;
      }
      else {
        return "";
      }
    }
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    if (this._tfp.isDesigning) {
      return super.getHtml("div", false, parentIndent, retainStyleAttr);
    } else {
      return super.getHtml("select", false, parentIndent, retainStyleAttr);
    }
  }
}