import TFPComponentRender from '../render.js'

export default class SelectRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getAttrHtml(retainStyleAttr, otherOptions) {
    var attrHtml = super.getAttrHtml(retainStyleAttr);

    if (!this._tfp.isDesigning) {
      var vid = escape(this.dataModel.id).replaceAll("%", "");
      attrHtml += " mode=\"selector\"";
      if (otherOptions && otherOptions.gridContainer) {
        attrHtml += " name=\"" + this.dataModel.id + "_{{index}}\"";
        attrHtml += " value=\"{{item." + vid + "}}\"";
      }
      else {
        attrHtml += " name=\"" + this.dataModel.id + "\"";
        attrHtml += " value=\"{{" + vid + "}}\"";

      }
      attrHtml += " range=\"{{" + vid + "_array}}\"";
      attrHtml += " range-key=\"{{'text'}}\" bindchange=\"bindchange_controller\"";
    }

    return attrHtml;
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let val = "";
    if (this.dataModel.value) {
      val = this.dataModel.value;
    }

    html += indent + "\t<div class=\"wx-select-picker\">" + val + "</div>\r\n";
    return html + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }

    var vid = escape(this.dataModel.id).replaceAll("%", "");
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    bodyHtml += indent + "\t<view class=\"wx-select-picker\">";
    if (otherOptions && otherOptions.gridContainer)
      bodyHtml += "{{" + vid + "_array[item." + vid + "].text}}";
    else
      bodyHtml += "{{" + vid + "_array[" + vid + "].text}}";
    bodyHtml += "</view>\r\n";

    cpt_wx.wxml = bodyHtml + indent;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("picker", false, parentIndent, retainStyleAttr, otherOptions);
  }
}