export default {
  "name": "Select",
  "comment": "下拉列表",
  "cssFiles": ["style.css", "style.{bgColorMode}.css"],
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "组件值",
          "type": "String"
        },
        {
          "name": "comment",
          "comment": "组件备注",
          "type": "String"
        },
        {
          "name": "options",
          "comment": "选项",
          "type": "Dataset"
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "encrypted",
          "comment": "加密发送",
          "type": "Switch"
        }
      ]
    },
    {
      "name": "dataSourceSetting",
      "comment": "数据源设置",
      "type": "group",
      "items": [
        {
          "name": "dataQuerySetting",
          "comment": "数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px"
        },
        {
          "name": "valueField",
          "comment": "选项值字段",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "textField",
          "comment": "选项文本字段",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "showTree",
          "comment": "显示树形结构",
          "type": "Switch"
        },
        {
          "name": "parentIdField",
          "comment": "父节点主键字段",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "rootParentId",
          "comment": "根节点主键值",
          "type": "String",
          "default": "0"
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "specialStyles": ["width", "height"],
  "defaultStyles": {
    "width": "120px",
    "height": "30px",
    "line-height": "30px",
    "padding-left": "2px",
    "padding-right": "2px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时"
    }, {
      "name": "onFocus",
      "comment": "获得焦点时"
    }, {
      "name": "onBlur",
      "comment": "失去焦点时"
    }, {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }, {
      "name": "onAfterLoadData",
      "comment": "加载数据后",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "req",
        "type": "Object",
        "comment": "请求对象"
      },{
        "name": "res",
        "type": "Object",
        "comment": "响应对象"
      }]
    }, {
      "name": "onBindData",
      "comment": "绑定数据后",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "data",
        "type": "Object",
        "comment": "绑定的数据"
      }]
    }],
  "methods": [{
    "name": "setOptions",
    "comment": "设置可选项",
    "args": [{
      "name": "options",
      "comment": "可选项",
      "type": "String"
    }]
  }, {
    "name": "addOption",
    "comment": "添加选项",
    "args": [{
      "name": "option",
      "comment": "选项",
      "type": "Object"
    }]
  }],
  "methods": [{
    "name": "bindData",
    "comment": "绑定数据",
    "args": [{
      "name": "data",
      "comment": "数据",
      "type": "Array"
    }]
  }, {
    "name": "getOption",
    "comment": "获得指定索引的选项",
    "args": [{
      "name": "index",
      "comment": "选项索引",
      "type": "Int"
    }]
  }, {
    "name": "getOptionByValue",
    "comment": "获得指定值的选项",
    "args": [{
      "name": "val",
      "comment": "选项值",
      "type": "String"
    }]
  }, {
    "name": "loadData",
    "comment": "加载数据",
    "args": []
  }, {
    "name": "setOptions",
    "comment": "设置可选项",
    "args": [{
      "name": "options",
      "comment": "可选项",
      "type": "String"
    }]
  }]
}