import { FormInput } from "../controller.js";

/**
 * 列表组件
 * @param {[type]} dataModel [description]
 */
export default class Select extends FormInput {

  constructor(__tfp, dataModel, parent, inputType) {
    if (inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "Select", dataModel, parent);
    }
  }

  //属性
  get value() {
    if (!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value(value) {
    if (value == "") {
      this.dataModel.value = "";
      this._jqObj.val("");
    } else {
      if (this._jqObj && this.dataModel.options) {
        for (var i = 0; i < this.dataModel.options.length; i++) {
          let option = this.dataModel.options[i];
          if (option.value == value) {
            this._jqObj.val((option.text != null && option.text != undefined) ? option.text : option.value);
            this.dataModel.value = option.value;
            if (this.dataModel.valueType == "text") this.dataModel.value = option.text;
            if (this.dataModel.valueType == "obj") this.dataModel.value = option;
            break;
          }
        }
      }
      else if (this._jqObj && this.dataModel.jsonDataSet && this.dataModel.jsonDataSet.options) {
        for (var i = 0; i < this.dataModel.jsonDataSet.options.length; i++) {
          let option = this.dataModel.jsonDataSet.options[i];
          if (option.value == value) {
            this._jqObj.val((option.text != null && option.text != undefined) ? option.text : option.value);
            this.dataModel.value = option.value;
            if (this.dataModel.valueType == "text") this.dataModel.value = option.text;
            if (this.dataModel.valueType == "obj") this.dataModel.value = option;
            break;
          }
        }
      }
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get options() { return this.dataModel.options }
  set options(value) {
    this.dataModel.options = value;
  }

  get valueType() { return this.dataModel.valueType }
  set valueType(value) {
    if (!this.checkAttrOption("valueType", value)) {
      this._tfp.showMsg("不支持类型：" + value + "！");
      return;
    }
    this.dataModel.valueType = value;
  }

  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) { this.dataModel.dataBindingMember = value }

  get valueField() { return this.dataModel.valueField }
  set valueField(value) { this.dataModel.valueField = value }

  get textField() { return this.dataModel.textField }
  set textField(value) { this.dataModel.textField = value }

  addOption(option) {
    if (!this.dataModel.options) this.dataModel.options = [];
    this.dataModel.options.push(option);
  }

  bindData(data, cb) {
    if (isNull(data) || !Array.isArray(data)) return;
    this.dataModel.options = [];
    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {};
      try {
        option.value = this._tfp.replaceDataField(row, "{" + this.dataModel.valueField + "}");
      } catch (e) {
        console.log(e);
        return;
      }
      if (isNull(option.value)) continue;
      if (this.dataModel.textField) {
        try {
          option.text = this._tfp.replaceDataField(row, "{" + this.dataModel.textField + "}");
        } catch (e) {
          console.log(e);
          return;
        }
      }
      this.dataModel.options.push(option);
      //显示组件当前值对应的文本
      if (option.value == this.dataModel.value && this._jqObj) {
        if (option.text) {
          this._jqObj.val(option.text);
        } else {
          this._jqObj.val(option.value);
        }
      }
    }
    if (cb) cb();
  }

  /**
   * 检查数据加载参数是否设置正确
   * @returns 
   */
  checkLoadDataArg() {
    if (!this.dataModel.valueField) {
      alert("请为[" + this.id + "]设置选项值字段格式！");
      return false;
    }
    return true;
  }

  onLoadData(req, res) {
    var dataBindingMember = this.dataModel.dataBindingMember; //某些老版本的组件使用的该属性，需要兼容

    if (this.dataModel.dataListBindingMember) {
      dataBindingMember = this.dataModel.dataListBindingMember;
    } else if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
      dataBindingMember = this.dataModel.dataQuerySetting.dataMember;
    }

    if (!dataBindingMember) {
      this._tfp.showMsg("请为[" + this.id + "]设置数据绑定成员！");

      return;
    }
    var data = res[dataBindingMember];

    let that = this;
    this.bindData(data, function () {
      window.popupList.show([{
        options: that.dataModel.options,
        value: that.dataModel.value
      }], function (vals) {
        if (vals.length > 0) {
          that.value = vals[0];
          for (var i = 0; i < that.dataModel.options.length; i++) {
            let option = that.dataModel.options[i];
            if (option.value == vals[0]) {
              that._jqObj.val((option.text != null && option.text != undefined) ? option.text : option.value);
              break;
            }
          }
        }
        else that.value = "";
      });
    });
  }

  showPopupList() {
    let that = this;
    if (this.dataModel.loadDataService //某些老版本的组件使用的该属性，需要兼容
      || (this.dataModel.dataQuerySetting
        && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
      )) {
      this.loadData();
    } else if (this.dataModel.options) {
      window.popupList.show([{
        options: this.dataModel.options,
        value: this.dataModel.value
      }], function (vals) {
        if (vals.length > 0) {
          that.value = vals[0];
          for (var i = 0; i < that.dataModel.options.length; i++) {
            let option = that.dataModel.options[i];
            if (option.value == vals[0]) {
              that._jqObj.val((option.text != null && option.text != undefined) ? option.text : option.value);
              break;
            }
          }
        }
        else that.value = "";
      });
    } else if (this.dataModel.jsonDataSet && this.dataModel.jsonDataSet.options) {
      window.popupList.show([{
        options: this.dataModel.jsonDataSet.options,
        value: this.dataModel.value
      }], function (vals) {
        if (vals.length > 0) {
          that.value = vals[0];
          for (var i = 0; i < that.dataModel.options.length; i++) {
            let option = that.dataModel.options[i];
            if (option.value == vals[0]) {
              that._jqObj.val((option.text != null && option.text != undefined) ? option.text : option.value);
              break;
            }
          }
        }
        else that.value = "";
      });
    }
  }

  initRuntime() {
    if (this.dataModel.loadDataService) {
      //不要在初始化时加载，在点击后弹出列表时加载
      // this.loadData();
    }

    let that = this;
    this._jqObj.click(function () {
      if (that.dataModel.readonly || that.dataModel.disabled) return;
      if (!window.popupList) {
        that._tfp.use(["PopupList"], function () {
          let popupListClass = that._tfp.controllers["PopupList"];
          window.popupList = new popupListClass(that._tfp, {
            "id": "popupList",
            "type": "PopupList"
          });
          that.showPopupList();
        });
        return;
      }
      that.showPopupList();
    });
  }
}