import { FormInput } from "../controller.js";

/**
 * 下拉列表组件
 * @param {[type]} dataModel [description]
 */
export default class Select extends FormInput {

  constructor(__tfp, dataModel, parent, inputType) {
    if (inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "Select", dataModel, parent);
    }
    this.isSetOptions = false;
  }

  get value() {
    if (!this._tfp.isDesigning && this._jqObj && this.isSetOptions && this.dataModel.value != this._jqObj.val())
      this.dataModel.value = this._jqObj.val();
    if (this._tfp.isNull(this.dataModel.value)) return "";
    return this.dataModel.value;
  }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj && !this._tfp.isDesigning && this.dataModel.options) {
      if (this.dataModel.readonly) {
        for (var i = 0; i < this.dataModel.options.length; i++) {
          if (this.dataModel.options[i].value == value) {
            var txt = this.dataModel.options[i].text;
            if (!txt) txt = value;
            this._jqObj.empty();
            this._jqObj.append("<option value=\"" + value + "\">" + txt + "</option>");
            return;
          }
        }
      } else {
        this._jqObj.val(value);
      }
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get text() {
    if (!this.options) return "";
    let text = "";
    for (let i = 0; i < this.options.length; i++) {
      let option = this.options[i];
      if (option.value == this.value) {
        text = option.text;
        if (!option.text && option.text != 0) text = option.value;
        break;
      }
    }
    return text;
  }

  get options() { return this.dataModel.options }
  set options(value) {
    if (this._tfp.isDesigning) {
      this.dataModel.options = value;
      return;
    }
    if (this._jqObj && value && Array.isArray(value)) {
      this._jqObj.empty();
      this.dataModel.options = [];
      //即使必填，默认可以为空，但提交时如果为空则提示
      //否则，必填时默认选择一个值，用户就可能不选了
      //if (!this.required && !this.dataModel.readonly) 
        this._jqObj.append("<option value=\"\"></option>");
      let exists = false;
      for (var i = 0; i < value.length; i++) {
        if(this.addOption(value[i])) exists = true;
      }
      //如果重置选项列表后，没有组件当前值对应的选项，应该把组件值设置为空
      if(!exists && value.length>0) {
        //如果是必填，则选中第一个值
        //if(this.dataModel.required) {
        //  if(this.options.length>0) this.dataModel.value = this.options[0].value;
        //}
        //否则，清空原来的值
        //else 
        if(!this._tfp.isNull(this.dataModel.value)) {
          this.dataModel.value = null;
        }
      }
    }
    this.isSetOptions = true;
  }

  get jsonDataSet() { return this.dataModel.jsonDataSet }
  set jsonDataSet(value) {
    this.dataModel.jsonDataSet = value;
  }

  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) { this.dataModel.dataBindingMember = value }

  get valueField() { return this.dataModel.valueField }
  set valueField(value) { this.dataModel.valueField = value }

  get textField() { return this.dataModel.textField }
  set textField(value) { this.dataModel.textField = value }

  get showTree() { return this.dataModel.showTree }
  set showTree(value) { this.dataModel.showTree = value ? true : false }

  get parentIdField() { return this.dataModel.parentIdField }
  set parentIdField(value) { this.dataModel.parentIdField = value }

  get rootParentId() { return this.dataModel.rootParentId }
  set rootParentId(value) { this.dataModel.rootParentId = value }

  /**
   * 添加选项
   * @param {*} option 
   * @returns true表示新加的选项与组件值相等，否则不等
   */
  addOption(option) {
    if (!option) return false;
    let opt = option;
    if (typeof (opt) == "string") opt = { value: option, text: option };
    if (!this.dataModel.options) this.dataModel.options = [];
    this.dataModel.options.push(opt);
    let txt = opt.text;
    if (!txt) txt = opt.value;
    this._jqObj.append("<option value=\"" + opt.value + "\">" + txt + "</option>");
    if (opt.value == this.dataModel.value) {
      this._jqObj.val(opt.value);
      return true;
    }
    return false;
  }

  getOption(index) {
    return this.dataModel.options[index];
  }

  getOptionByValue(val) {
    return this.dataModel.options.find(v => v.value == val);
  }

  createTree(data) {
    this.nodes = {};
    this.rootNodes = [];
    let nodeIdArr = [];
    for (var i = 0; i < data.length; i++) {
      var nodeData = data[i];
      var node = {};
      node.id = nodeData[this.dataModel.valueField];
      node.name = nodeData[this.dataModel.textField];
      if (!this.dataModel.textField) node.name = nodeData[this.dataModel.valueField];
      node.parentId = nodeData[this.dataModel.parentIdField];
      node.data = nodeData;
      node.childNodes = [];
      this.nodes[node.id] = node;
      nodeIdArr.push(node.id);
    }

    //生成节点之间的关系
    for (var i = 0; i < nodeIdArr.length; i++) {
      var nodeId = nodeIdArr[i];
      var node = this.nodes[nodeId];
      if (node.parentId == this.dataModel.rootParentId) {
        this.rootNodes.push(nodeId);
      } else {
        var parentNode = this.nodes[node.parentId];
        if (parentNode) {
          parentNode.childNodes.push(nodeId);
        }
      }
    }

    this.options = [];

    for (var i = 0; i < this.rootNodes.length; i++) {
      var node = this.nodes[this.rootNodes[i]];
      if (!node.parentId) node.parentId = this.dataModel.rootParentId;
      this.createTreeNode(node, "");
    }

    if (this.dataModel.onBindData) {
      try {
        eval(this.dataModel.onBindData);
      } catch (err) {
        console.log(err);
      }
    }
  }

  createTreeNode(node, prefix) {
    this.addOption({ value: node.id, text: prefix + node.name });
    for (var i = 0; i < node.childNodes.length; i++) {
      var childNode = this.nodes[node.childNodes[i]];
      this.createTreeNode(childNode, prefix + "--");
    }
  }

  bindData(data) {
    if (isNull(data) || !Array.isArray(data)) return;
    if (this.dataModel.showTree && this.dataModel.parentIdField) {
      this.createTree(data);
      return;
    }
    let optionsTmp = [];
    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {
        data: row
      };
      try {
        option.value = this._tfp.replaceDataField(row, "{" + this.dataModel.valueField + "}");
      } catch (e) {
        console.log(e);
        return;
      }
      if (isNull(option.value)) continue;
      if (this.dataModel.textField) {
        try {
          option.text = this._tfp.replaceDataField(row, "{" + this.dataModel.textField + "}");
        } catch (e) {
          console.log(e);
          return;
        }
      }
      optionsTmp.push(option);
    }
    this.options = optionsTmp;
    if (this.dataModel.onBindData) {
      try {
        eval(this.dataModel.onBindData);
      } catch (err) {
        console.log(err);
      }
    }
  }

  /**
   * 检查数据加载参数是否设置正确
   * @returns 
   */
  checkLoadDataArg() {
    if (!this.dataModel.valueField) {
      alert("请为[" + this.id + "]设置选项值字段格式！");
      return false;
    }
    return true;
  }

  initRuntime() {
    if (this.dataModel.jsonDataSet) {
      this.dataModel.loadDataService = this.dataModel.jsonDataSet.loadDataService;
      this.dataModel.dataBindingMember = this.dataModel.jsonDataSet.dataBindingMember;
      this.dataModel.valueField = this.dataModel.jsonDataSet.valueField;
      this.dataModel.textField = this.dataModel.jsonDataSet.textField;
      this.dataModel.parentIdField = this.dataModel.jsonDataSet.parentIdField;
      this.dataModel.options = this.dataModel.jsonDataSet.options;
      // this.dataModel.defaultValue = this.dataModel.jsonDataSet.defaultValue;
    }

    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService
      || (this.dataModel.dataQuerySetting
        && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
      )) {
      this.loadData();
    }

    if (this.dataModel.readonly) {
      this._jqObj.prop("disabled", true);
      this._jqObj.css({ "-webkit-appearance": "none", "line-height": "20px" });
      return;
    }

    let that = this;
    this._jqObj.change(function () {
      that.dataModel.value = $(this).val();
      that.valueOnChange();
      that.exeEventHandler("onChange", that.dataModel.value);
    });
  }
}