import { FormInput } from "../controller.js";

/**
 * 下拉列表组件
 * @param {[type]} dataModel [description]
 */
export default class Select extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Select", dataModel, parent);
  }

  //属性
  get value() { return this.dataModel.value; }
  set value(value) {
    this.dataModel.value = value;

    if (this._jqObj && this.dataModel.options) {
      for (var i = 0; i < this.dataModel.options.length; i++) {
        let option = this.dataModel.options[i];
        if (option.value == value) {
          this._jqObj.val((option.text != null && option.text != undefined) ? option.text : option.value);
          break;
        }
      }
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get options() { return this.dataModel.options }
  set options(value) {
    this.dataModel.options = value;
  }

  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) { this.dataModel.dataBindingMember = value }

  get valueField() { return this.dataModel.valueField }
  set valueField(value) { this.dataModel.valueField = value }

  get textField() { return this.dataModel.textField }
  set textField(value) { this.dataModel.textField = value }

  addOption(option) {
    if (!this.dataModel.options) this.dataModel.options = [];
    this.dataModel.options.push(option);
  }

  bindData(data) {
    if (isNull(data) || !Array.isArray(data)) return;
    this.dataModel.options = [];
    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {};
      try {
        option.value = this._tfp.replaceDataField(row, "{" + this.dataModel.valueField + "}");
      } catch (e) {
        console.log(e);
        return;
      }
      if (isNull(option.value)) continue;
      if (this.dataModel.textField) {
        try {
          option.text = this._tfp.replaceDataField(row, "{" + this.dataModel.textField + "}");
        } catch (e) {
          console.log(e);
          return;
        }
      }
      this.dataModel.options.push(option);
      //显示组件当前值对应的文本
      if (option.value == this.dataModel.value && this._jqObj) {
        if (option.text) {
          this._jqObj.val(option.text);
        } else {
          this._jqObj.val(option.value);
        }
      }
    }
  }

  loadData() {
    if (!this.dataModel.loadDataService) {
      alert("请为[" + this.id + "]设置加载数据服务！");
      return;
    }
    let serviceCpt = this._tfp.get(this.dataModel.loadDataService);
    if (!serviceCpt) {
      alert("ID为[" + this.dataModel.loadDataService + "]的组件不存在！");
      return;
    }
    if (!this.dataModel.dataBindingMember) {
      alert("请为[" + this.id + "]设置数据绑定成员！");
      return;
    }
    if (!this.dataModel.valueField) {
      alert("请为[" + this.id + "]设置选项值字段格式！");
      return;
    }

    let that = this;
    serviceCpt.request(null, function (req, res) {
      var data = res[that.dataModel.dataBindingMember];
      that.bindData(data);
    });
  }

  showPopupList() {
    let that = this;
    window.popupList.show([{
      options: this.dataModel.options,
      value: this.dataModel.value
    }], function (vals) {
      if (vals.length > 0) that.value = vals[0];
    });
  }

  initRuntime() {
    if (this.dataModel.loadDataService) {
      this.loadData();
    }

    let that = this;
    this._jqObj.click(function () {
      if (!window.popupList) {
        that._tfp.use(["PopupList"], function () {
          let popupListClass = that._tfp.controllers["PopupList"];
          window.popupList = new popupListClass(that._tfp, {
            "id": "popupList",
            "type": "PopupList"
          });
          that.showPopupList();
        });
        return;
      }
      that.showPopupList();
    });
  }
}