export default {
  "name": "Schedule",
  "comment": "日程",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "basicSetting",
      "comment": "基础设置",
      "type": "group",
      "items": [
        {
          "name": "options",
          "comment": "选项设置",
          "type": "Dataset",
          "isPro": true,
          "keyCol": "name",
          "width": "640px",
          "height": "600px",
          "columns": [
            {
              "id": "title",
              "name": "主题",
              "type": "String",
              "required": true
            },
            {
              "id": "content",
              "name": "描述",
              "type": "String"
            },
            {
              "id": "allDayEvent",
              "name": "全天计划",
              "type": "Switch",
              "default": true
            },
            {
              "id": "startTime",
              "name": "开始时间",
              "type": "String",
              "required": true
            },
            {
              "id": "endTime",
              "name": "结束时间",
              "type": "String",
              "required": true
            },
            {
              "id": "level",
              "name": "事件级别",
              "type": "Select",
              "default": "重要且紧急",
              "options": [
                {
                  "value": "重要且紧急",
                  "text": "重要且紧急"
                },
                {
                  "value": "重要不紧急",
                  "text": "重要不紧急"
                },
                {
                  "value": "紧急不重要",
                  "text": "紧急不重要"
                },
                {
                  "value": "不重要不紧急",
                  "text": "不重要不紧急"
                }
              ]
            }
          ]
        },
        {
          "name": "minHeight",
          "comment": "行高",
          "type": "String",
          "default": "60"
        },
      ]
    },
    {
      "name": "statusSetting",
      "comment": "事件级别设置",
      "type": "group",
      "items": [
        {
          "name": "importantAndUrgentColor",
          "comment": "重要且紧急状态颜色",
          "type": "Color",
          "default": "#f56c6c"
        },
        {
          "name": "importantButNotUrgentColor",
          "comment": "重要不紧急状态颜色",
          "type": "Color",
          "default": "#ff9900"
        },
        {
          "name": "urgentNotImportantColor",
          "comment": "紧急不重要状态颜色",
          "type": "Color",
          "default": "#e7ed6c"
        },
        {
          "name": "notImportantNotUrgentColor",
          "comment": "不重要不紧急状态颜色",
          "type": "Color",
          "default": "#0099ff"
        }
      ]
    },
    {
      "name": "dataSourceSetting",
      "comment": "数据源设置",
      "type": "group",
      "items": [
        {
          "name": "dataQuerySetting",
          "comment": "数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px"
        },
        {
          "name": "dataListTitleFormat",
          "comment": "主题数据格式",
          "type": "String"
        },
        {
          "name": "dataListContentFormat",
          "comment": "描述数据格式",
          "type": "String"
        },
        {
          "name": "dataListStartTimeFormat",
          "comment": "开始时间数据格式",
          "type": "String"
        },
        {
          "name": "dataListEndTimeFormat",
          "comment": "结束时间数据格式",
          "type": "String"
        },
        {
          "name": "dataListLevelFormat",
          "comment": "事件级别数据格式",
          "type": "String"
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "680px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClickOption",
      "comment": "单击单元格时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "date",
          "comment": "选项值",
          "type": "String",
          "required": true
        }
      ]
    }, {
      "name": "onDblClickOption",
      "comment": "双击单元格时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "date",
          "comment": "选项值",
          "type": "String",
          "required": true
        }
      ]
    }]
}