import TFPComponentRender from '../render.js'

export default class ScanCodeRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    html += indent;
    if(!this.dataModel.value){
      this.dataModel.value = ''
    }
    if (this.dataModel.showType == 'input') {
      html += `<input class="wx-text" type="text" readonly value="` + this.dataModel.value + `"><view class="wx-scancode-icon"></view>`;
    } else {
      html += `<button><view class="wx-scancode-icon"></view></button>`;
    }
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", false, parentIndent, retainStyleAttr, otherOptions);
  }
}