import TFPComponentRender from '../render.js'

export default class ScanCodeRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    html += indent;
    if (this.dataModel.showType == 'input') {
      html += `<input class="wx-text" type="text" readonly><view class="wx-scancode-icon"></view>`;
    } else {
      html += `<button><view class="wx-scancode-icon"></view></button>`;
    }
    return html + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var vid = escape(this.dataModel.id).replaceAll("%", "");
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    bodyHtml += indent;
    if (this.dataModel.showType == 'input') {
      bodyHtml += `<input class="wx-text" type="text" value="{{` + vid + `}}" disabled bindtap="bindclick_scanCode" data-id="` + vid + `" data-type="` + this.dataModel.scanType + `"/><view class="wx-scancode-icon"></view>\n`;
    }else{
      bodyHtml += `<button bindtap="bindclick_scanCode" data-id="` + vid + `" data-type="` + this.dataModel.scanType + `"><view class="wx-scancode-icon"></view></button>\n`;
    }
    cpt_wx.wxml = bodyHtml + indent;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", false, parentIndent, retainStyleAttr, otherOptions);
  }
}