import { FormInput } from "../controller.js";

/**
 * 面板组件
 * @param {[type]} dataModel [description]
 */
export default class ScanCode extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "ScanCode", dataModel, parent);
  }

  get value() {
    return this.dataModel.value;
  }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      this._jqObj.find('.input').value(value)
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  // 展示方式
  get showType() { return this.dataModel.showType }
  set showType(value) {
    this.dataModel.showType = value;
    if (this._jqObj) {
      this._jqObj.empty();
      var html = '';
      if (value == 'input') {
        if (!this.dataModel.value) {
          this.dataModel.value = '';
        }
        html += `<input class="wx-text" type="text" readonly value="` + this.dataModel.value + `"><view class="wx-scancode-icon"></view>`;
      } else {
        html += `<button><view class="wx-scancode-icon"></view></button>`;
      }
      this._jqObj.html(html);
    }
  }

  // 初始化 运行时   页面渲染完成执行
  initRuntime() {
    var that = this;
    that._jqObj.click(function () {
      if (!that._tfp.isDesigning) {
        console.log(that)
        if (window.tmClient) {
          // alert(window.tmClient.mobileType)
          if (window.tmClient.mobileType == 'dingding') {
            window.tmClient.empower(function () {
              window.tmClient.showCodeScanner(function (text) {
                if(!text){
                  return;
                }
                that.dataModel.value = text;
                that._jqObj.find('.input').value(text)
              });
            })
          }
          if (window.tmClient.mobileType == 'workwx') {
            window.tmClient.empower(function () {
              window.tmClient.showCodeScanner(function (text) {
                if(!text){
                  return;
                }
                that.dataModel.value = text;
                that._jqObj.find('.input').value(text)
              });
            })
          }
          if (window.tmClient.mobileType == 'renxun') {
            tmClient.showCodeScanner({ isMulti: true, canAlbum: true, isRepetition: true }, function (text) {
              if(!text){
                return;
              }
              that.dataModel.value = text;
              that._jqObj.find('.input').value(text)
            });
          }
        }
      }
    })
  }
}