import { FormInput } from "../controller.js";

/**
 * 面板组件
 * @param {[type]} dataModel [description]
 */
export default class ScanCode extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "ScanCode", dataModel, parent);
  }

  get value() {
    return this.dataModel.value;
  }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      this._jqObj.find('.input').value(value)
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }


  // 展示方式
  get showType() { return this.dataModel.showType }
  set showType(value) {
    this.dataModel.showType = value;
    if (this._jqObj) {
      this._jqObj.empty();
      var html = '';
      if (value == 'input') {
        if(!this.dataModel.value){
          this.dataModel.value = '';
        }
        html += `<input class="wx-text" type="text" readonly value="` + this.dataModel.value + `"><view class="wx-scancode-icon"></view>`;
      } else {
        html += `<button><view class="wx-scancode-icon"></view></button>`;
      }
      this._jqObj.html(html);
    }
  }

  // 扫描方式
  get scanType() { return this.dataModel.scanType }
  set scanType(value) {
    this.dataModel.scanType = value;
  }
}