import TFPComponentRender from '../render.js'

export default class RichTextRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getBodyHtml = function(getComponentsHtml) {
    if(this._tfp.isDesigning) return "";
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    html = indent+"<textarea id=\""+this.cpt.id+"_textarea\"";
    if(this.readonly) html += " readonly";
    html += "></textarea>";
    return html;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}