import { FormInput } from "../controller.js";

/**
 * 评分组件
 * @param {[type]} dataModel [description]
 */
export default class Rate extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Rate", dataModel, parent);
  }

  get value() { return this.dataModel.value }
  set value(value) {
    if (value) {
      let val = parseFloat(value).toFixed(1);
      if (val <= 0) {
        val = "";
      } else if (val >= 5) {
        val = 5.0;
      } else {
        if (0 < parseInt((val + "").substring(2)) && parseInt((val + "").substring(2)) < 5) {
          val = parseFloat((val + "").substring(0, 1) + '.5');
        } else if (5 < parseInt((val + "").substring(2)) && parseInt((val + "").substring(2)) <= 9) {
          val = parseFloat((val + "").substring(0, 1) + '.0') + 1;
        }
      }
      this.dataModel.value = val;
    } else {
      this.dataModel.value = "";
    }
    if (!this._tfp.isDesigning) {
      this.setRateData();
    }
  }

  get showText() { return this.dataModel.showText }
  set showText(value) {
    this.dataModel.showText = value ? true : false;
    let cptWidth = 132;
    if (this.dataModel.showText || this.dataModel.readonly || this.dataModel.disabled) {
      cptWidth = 165;
    }
    this._jqObj.css("width", cptWidth + "px");
    this._jqObj.css("min-width", cptWidth + "px");
    if (!this.dataModel.styles) this.dataModel.styles = {};
    this.dataModel.styles["width"] = cptWidth + "px";
    this.dataModel.styles["min-width"] = cptWidth + "px";
    if (this._jqObj) {
      this.reRender();
    }
  }

  get readonly() { return this.dataModel.readonly }
  set readonly(value) {
    this.dataModel.readonly = value ? true : false;
    let cptWidth = 132;
    if (this.dataModel.showText || this.dataModel.readonly || this.dataModel.disabled) {
      cptWidth = 165;
    }
    this._jqObj.css("width", cptWidth + "px");
    this._jqObj.css("min-width", cptWidth + "px");
    if (!this.dataModel.styles) this.dataModel.styles = {};
    this.dataModel.styles["width"] = cptWidth + "px";
    this.dataModel.styles["min-width"] = cptWidth + "px";
    if (this._jqObj) {
      this.reRender();
    }
  }

  get disabled() { return this.dataModel.disabled }
  set disabled(value) {
    this.dataModel.disabled = value ? true : false;
    let cptWidth = 132;
    if (this.dataModel.showText || this.dataModel.readonly || this.dataModel.disabled) {
      cptWidth = 165;
    }
    this._jqObj.css("width", cptWidth + "px");
    this._jqObj.css("min-width", cptWidth + "px");
    if (!this.dataModel.styles) this.dataModel.styles = {};
    this.dataModel.styles["width"] = cptWidth + "px";
    this.dataModel.styles["min-width"] = cptWidth + "px";
    if (this._jqObj) {
      this.reRender();
    }
  }

  get halfStar() {
    return this._tfp.rootPath + "/src/components/" + this.type.toLowerCase()
      + "/images/halfStar.png";
  }
  set halfStar(value) { }

  get fullStar() {
    return this._tfp.rootPath + "/src/components/" + this.type.toLowerCase()
      + "/images/fullStar.png";
  }
  set fullStar(value) { }

  get emptyStar() {
    return this._tfp.rootPath + "/src/components/" + this.type.toLowerCase()
      + "/images/emptyStar.png";
  }
  set emptyStar(value) { }

  reRender() {
    this._jqObj.empty();
    this._jqObj.append(this.getBodyHtml());

    if (!this._tfp.isDesigning) {
      this.getRateData();
      this.setRateData();
    }
  }

  getBodyHtml(getComponentsHtml) {
    let indent = this.getHtmlIndent();
    let html = "\r\n";
    html += indent + `<ul>
              <li style="background:url(${this.emptyStar});"><a href="javascript:;">0.5</a><a href="javascript:;">1.0</a></li>
              <li style="background:url(${this.emptyStar});"><a href="javascript:;">1.5</a><a href="javascript:;">2.0</a></li>
              <li style="background:url(${this.emptyStar});"><a href="javascript:;">2.5</a><a href="javascript:;">3.0</a></li>
              <li style="background:url(${this.emptyStar});"><a href="javascript:;">3.5</a><a href="javascript:;">4.0</a></li>
              <li style="background:url(${this.emptyStar});"><a href="javascript:;">4.5</a><a href="javascript:;">5.0</a></li>
            </ul>`;
    if (this.dataModel.readonly || this.dataModel.disabled) {
      html += `<span>分值</span>`;
    } else if (this.dataModel.showText) {
      html += `<span>描述</span>`;
    }
    return html + "\t";
  }

  getRateData() {
    let that = this;
    let text = {
      "0": "极差",
      "1": "失望",
      "2": "一般",
      "3": "满意",
      "4": "惊喜"
    }

    this._jqObj.find("a").on("mouseenter", function () {
      //判断是全星点还是半星点
      if ($(this).html().substring(2) == "5") {
        $(this).parent().css("background", "url(" + that.halfStar + ")");
      } else {
        $(this).parent().css("background", "url(" + that.fullStar + ")");
      }
      //对前方的星星进行处理，遍历前方的li使背景图均变为全星
      var prev = $(this).parent();
      for (var i = 0; i <= parseInt($(this).html()) - 1; i++) {
        prev.prev().css("background", "url(" + that.fullStar + ")");
        prev = prev.prev();
      }
      //对后方星星进行处理，遍历后面的li使背景图均变为空星
      var after = $(this).parent();
      for (var i = 0; i <= (4 - parseInt($(this).html())); i++) {
        after.next().css("background", "url(" + that.emptyStar + ")");
        after = after.next();
      }
      if (that.dataModel.showText) {
        for (let k in text) {
          if ($(this).parent().index() == k) {
            that._jqObj.find("span").text(text[k]);
          }
        }
      }

      that._jqObj.find("a").off('click').on("click", function () {
        that.dataModel.value = $(this).html();
      })
    })

    this._jqObj.find("ul").on("mouseleave", function () {
      that.setRateData()
    })
  }

  setRateData() {
    let that = this;
    let value = that.dataModel.value;
    let text = {
      "0": "极差",
      "1": "失望",
      "2": "一般",
      "3": "满意",
      "4": "惊喜"
    }

    if (that.dataModel.showText || that.dataModel.readonly || that.dataModel.disabled) that._jqObj.find("span").text("");
    if (value) {
      let index = "";
      if ((value + "").substring(2) == "5") {
        index = value - 0.5
      } else {
        index = value - 1
      }
      if (that.dataModel.showText) {
        that._jqObj.find("span").text(text[index]);
      }
      if (that.dataModel.readonly || that.dataModel.disabled) {
        that._jqObj.find("span").css("color", "#ffc844").text(value);
      }
      for (var i = 0; i < that._jqObj.find("li").length; i++) {
        if (i == index) {
          if ((value + "").substring(2) == "5") {
            that._jqObj.find("li").eq(i).css("background", "url(" + that.halfStar + ")");
          } else {
            that._jqObj.find("li").eq(i).css("background", "url(" + that.fullStar + ")");
          }
        }
        if (i > index) that._jqObj.find("li").eq(i).css("background", "url(" + that.emptyStar + ")");
        if (i < index) that._jqObj.find("li").eq(i).css("background", "url(" + that.fullStar + ")");
      }
    } else {
      that._jqObj.find("li").css("background", "url(" + that.emptyStar + ")");
    }
  }

  initRuntime() {
    let that = this;
    if (that.dataModel.readonly || that.dataModel.disabled) return that.setRateData();
    that.reRender();
  }
}