import { FormInput } from "../controller.js";

/**
 * 单选框组件
 * @param {[type]} dataModel [description]
 */
export default class Radio extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Radio", dataModel, parent);
  }

  //属性
  get value() { return this.dataModel.value; }
  set value(value) {
    var self = this;
    this.dataModel.value = value;

    if (this._jqObj) {
      this._jqObj.find(".wx-radio-input").each(function () {
        if ($(this).attr("data-option") == value) {
          $(this).attr("checked", "checked");
          $(this).css("background-color", self.dataModel.controlColor);
        } else {
          $(this).removeAttr("checked");
          $(this).css("background-color", "#ffffff");
        }
      });
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get options() { return this.dataModel.options; }
  set options(value) {
    if (!value) return;
    this.setOptions(value);
    if (this._jqObj) {
      this._jqObj.empty();
      for (var i = 0; i < value.length; i++) {
        this.addOption(value[i], true);
      }
    }
  }

  get controlColor() { return this.dataModel.controlColor }
  set controlColor(value) {
    this.dataModel.controlColor = value;
  }

  // get flex() { return this.dataModel.flex; }
  // set flex(value) {
  //   this.dataModel.flex = value;
  //   this._jqObj.children().each(function () {
  //     $(this).removeClass()
  //   })
  //   this._jqObj.children().addClass("radio-" + value + "-" + this.dataModel.alignType);
  // }

  // get alignType() { return this.dataModel.alignType; }
  // set alignType(value) {
  //   this.dataModel.alignType = value;
  //   this._jqObj.children().each(function () {
  //     $(this).removeClass()
  //   })
  //   this._jqObj.children().addClass("radio-" + this.dataModel.flex + "-" + value);
  // }

  get portrait() { return this.dataModel.portrait }
  set portrait(value) {
    this.dataModel.portrait = value ? true : false;

    if (this._jqObj) {
      if (value) {
        this._jqObj.find(".wx-radio-box").removeClass("wx-inlineblock").addClass("wx-inline");
      } else {
        this._jqObj.find(".wx-radio-box").removeClass("wx-inline").addClass("wx-inlineblock");
      }
    }
  }

  getOptionHtml(indent, option) {
    let optionHtml = "";
    optionHtml += indent;
    optionHtml += "\t<div class=\"wx-radio-box";
    if (this.dataModel.portrait) optionHtml += " wx-inline";
    else optionHtml += " wx-inlineblock";
    optionHtml += "\">";
    optionHtml += "<div class=\"wx-radio-input\" ";
    optionHtml += " data-option=\"" + option.value + "\"";
    if (this.dataModel.value && this.dataModel.value + "" == option.value + "") {
      optionHtml += " checked";
      optionHtml += " style=\"background-color:" + this.dataModel.controlColor + "\"";
    }
    else {
      optionHtml += " style=\"background-color:#ffffff;\"";
    }
    // optionHtml += ">";
    // optionHtml += "<div class=\"wx-radio-item\"";
    optionHtml += ">√</div>";
    // optionHtml += "</div>";
    if (option.text) {
      optionHtml += "<div class=\"wx-radio-label\">" + option.text + "</div>";
    } else {
      optionHtml += "<div class=\"wx-radio-label\">" + option.value + "</div>";
    }
    optionHtml += "</div>\r\n";
    return optionHtml;
  }

  getOptionWx(indent, option, index) {
    var vid = escape(this.dataModel.id).replaceAll("%", "");
    let optionHtml = "";
    optionHtml += indent;
    optionHtml += "\t<view class=\"wx-radio-box";
    if (this.dataModel.portrait) optionHtml += " wx-inline";
    else optionHtml += " wx-inlineblock";
    optionHtml += "\">";
    optionHtml += "<radio";
    optionHtml += " value=\"" + option.value + "\"";
    optionHtml += " checked=\"{{" + vid + "_" + index + "}}\"";
    optionHtml += ">";
    if (option.text) {
      optionHtml += "<text class=\"wx-radio-text\">" + option.text + "</text>";
    } else {
      optionHtml += "<text class=\"wx-radio-text\">" + option.value + "</text>";
    }
    optionHtml += "</radio>";
    optionHtml += "</view>\r\n";
    return optionHtml;
  }

  addOption(option, isInit) {
    let indent = this.getHtmlIndent();
    let str = "";
    // if (this.portrait && this._jqObj.children().length > 0)
    //   str += indent + "\t<br>\r\n";
    str += this.getOptionHtml(indent, option);
    if (str != "") {
      this._jqObj.append(str);
      this.bindOptionEvent(this._jqObj.find(".wx-radio-box").last().get(0));
      if (!isInit) this.dataModel.options.push(option);
    }
  }

  // getOptionWx(indent, option) {
  //   let optionHtml = "";
  //   optionHtml += indent + `\t<label class=\"wx-radio-box\ radio-${this.dataModel.flex}-${this.dataModel.alignType}" > 
  //    <radio value="${option.id}" checked="{{${option.id}}}" ${option.disabled ? 'disabled' : ''} color="${option.color ? option.color : '#09BB07'}"  />${option.name} </label>\r\n`
  //   return optionHtml;
  // }

  // addOptionWx(option, isInit) {
  //   let indent = this.getHtmlIndent();
  //   let str = "";
  //   if (this._jqObj.children().length > 0)
  //     str += indent + "\t\r\n";
  //   str += this.getOptionWx(indent, option);
  //   if (str != "") {
  //     this._jqObj.append(str);
  //     this.bindOptionEvent(this._jqObj.find(".tfp-radio-box").last().get(0));
  //     if (!isInit) this.dataModel.options.push(option);
  //   }
  // }

  bindOptionEvent(el) {
    let that = this;
    $(el).click(function () {
      if (that.dataModel.disabled || that.dataModel.readonly) return;
      that.value = $(this).attr("data-option");
    });
  }

  initRuntime() {
    let that = this;
    this._jqObj.find(".wx-radio-box").each(function () {
      that.bindOptionEvent(this);
    });
  }
}