import { FormInput } from "../controller.js";

/**
 * 单选框组件
 * @param {[type]} dataModel [description]
 */
export default class Radio extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Radio", dataModel, parent);
  }

  get value() { return this.dataModel.value; }
  set value(value) {
    this.dataModel.value = value;
    if (this.dataModel.readonly) {
      this._jqObj.empty();
      this._jqObj.append(this.addReadonlyOption());
    } else {
      this.checkOptionByValue();
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get text() {
    if (!this.dataModel.value) return "";
    let item = this.dataModel.options.find(v => v.value == this.dataModel.value);
    if (!item) return "";
    return item.text;
  }
  set text(txt) {
  }

  get options() { return this.dataModel.options }
  set options(value) {
    if (!value) return;
    this.setOptions(value);
    if (this._jqObj) {
      if (this.dataModel.readonly) {
        this._jqObj.empty();
        this._jqObj.append(this.addReadonlyOption());
      } else {
        if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") {
          this.reRender();
        } else {
          this._jqObj.empty();
          for (var i = 0; i < value.length; i++) {
            this.addOption(value[i], true, i);
          }
        }
      }
    }
  }

  get valueField() { return this.dataModel.valueField }
  set valueField(value) { this.dataModel.valueField = value }

  get textField() { return this.dataModel.textField }
  set textField(value) { this.dataModel.textField = value }

  get jsonDataSet() { return this.dataModel.jsonDataSet }
  set jsonDataSet(value) {
    this.dataModel.jsonDataSet = value;
  }

  get typeCode() { return this.dataModel.typeCode }
  set typeCode(value) { this.dataModel.typeCode = value }

  get portrait() { return this.dataModel.portrait }
  set portrait(value) {
    this.dataModel.portrait = value ? true : false;
    if (this._jqObj) {
      if (value && this.dataModel.showStyle == 'defaultMode') {
        let that = this;
        this._jqObj.find("label").each(function (index) {
          if (index < (that._jqObj.find("label").length - 1)) {
            $("<br/>").insertAfter($(this));
          }
        });
      } else {
        this._jqObj.find("br").remove();
      }
    }
  }

  get showStyle() { return this.dataModel.showStyle }
  set showStyle(value) {
    this.dataModel.showStyle = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  reRender() {
    this._jqObj.empty();
    this._jqObj.append(this.getBodyHtml());
  }

  checkOptionByValue() {
    const that = this;
    if (this._jqObj) {
      if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") {
        this._jqObj.find(".tfp-radio-item").each(function () {
          if ($(this).attr("data-option") == that.dataModel.value) {
            $(this).addClass("tfp-radio-item-selected");
          } else {
            $(this).removeClass("tfp-radio-item-selected");
          }
        });
      }
      else {
        this._jqObj.find(".tfp-radio-box").each(function () {
          if ($(this).attr("data-option") == that.dataModel.value) {
            $(this).find("div").css("display", "block");
          } else {
            $(this).find("div").css("display", "none");
          }
        });
      }
    }
  }

  getBodyHtml(getComponentsHtml) {
    let that = this;
    let bodyHtml = "\r\n";
    if (this.dataModel.jsonDataSet) {
      this.dataModel.options = this.dataModel.jsonDataSet.options;
    }
    if (!this.dataModel.options) return bodyHtml;
    let indent = this.getHtmlIndent();
    if (this.dataModel.readonly) {
      let optionReadonlyHtml = this.addReadonlyOption();
      bodyHtml += optionReadonlyHtml;
    } else {
      if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") {
        bodyHtml += "<div class=\"tfp-radio-button\">"; //style=\"width:calc(70px * " + this.dataModel.options.length + ")\">"
      }
      for (var i = 0; i < this.dataModel.options.length; i++) {
        var option = this.dataModel.options[i];

        if (this.dataModel.portrait && this.dataModel.showStyle == 'defaultMode') bodyHtml += indent + "\t<div class=\"tfp-radio-row\">\r\n";
        let optionHtml = this.getOptionHtml(indent + "\t", option, i);
        if (this.dataModel.portrait && this.dataModel.showStyle == 'defaultMode') {
          optionHtml = optionHtml.replaceAll("tfp-radio-box", "tfp-radio-box tfp-radio-box-portrait");
          optionHtml = optionHtml.replaceAll("tfp-radio-label", "tfp-radio-label tfp-radio-label-portrait");
        } else {
          optionHtml = optionHtml.replaceAll("tfp-radio-box", "tfp-radio-box tfp-radio-box-lateral");
          optionHtml = optionHtml.replaceAll("tfp-radio-label", "tfp-radio-label tfp-radio-label-lateral");
        }
        bodyHtml += optionHtml;
        if (this.dataModel.portrait && this.dataModel.showStyle == 'defaultMode') bodyHtml += indent + "\t</div>\r\n";
      }
      if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") bodyHtml += "</div>"
    }

    return bodyHtml + indent;
  }

  getOption(index) {
    return this.dataModel.options[index];
  }

  getOptionByValue(val) {
    return this.dataModel.options.find(v => v.value == val);
  }

  getOptionHtml(indent, option, index) {
    let optionHtml = "";

    if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") {
      let displayColor = "";
      let displayBgColor = "";
      let cursorStyle = "pointer";
      let classSelected = "";
      if (this.value == option.value) {
        classSelected = " tfp-radio-item-selected";
        if (this.dataModel.disabled) displayBgColor = "#f2f6fc";
      }
      if (this.dataModel.disabled) {
        displayColor = "#c0c4cc";
        cursorStyle = "not-allowed";
      }

      optionHtml += indent + "\t<div class=\"tfp-radio-item" + classSelected + "\" data-option=\""
        + option.value + "\" style=\"cursor:" + cursorStyle + ";";
      if (displayColor != "") optionHtml += "color:" + displayColor + ";";
      if (displayBgColor != "") optionHtml += "background-color:" + displayBgColor + ";";
      if (this.dataModel.showStyle == "disperseMode") optionHtml += "margin-right: 10px;border-radius: 15px;border:0px;";
      if (this.dataModel.showStyle == "buttonMode" && index == 0) optionHtml += "border-radius: 4px 0 0 4px;";
      if (this.dataModel.showStyle == "buttonMode" && index == this.dataModel.options.length - 1) optionHtml += "border-radius: 0 4px 4px 0;";
      optionHtml += "\">";
      if (option.text) {
        optionHtml += option.text;
      } else {
        optionHtml += option.value;
      }
      optionHtml += "</div>";
    }
    else {
      let optionDisplay = "none";
      if (this.value == option.value) optionDisplay = "block";
      let disabledStyle = "";
      if (this.dataModel.disabled) disabledStyle = " style=\"background-color:#eeeeee;\"";

      optionHtml += indent + "\t<div class=\"tfp-radio-box\" "
        + disabledStyle + " data-option=\"" + option.value + "\">"
        + "<div style=\"display:" + optionDisplay + ";\"></div></div>";
      if (option.text) {
        optionHtml += "<label class=\"tfp-radio-label\">" + option.text + "</label>\r\n";
      } else {
        optionHtml += "<label class=\"tfp-radio-label\">" + option.value + "</label>\r\n";
      }
    }
    return optionHtml;
  }

  addReadonlyOption() {
    let optionHtml = "";
    let text = "";
    for (var i = 0; i < this.dataModel.options.length; i++) {
      let option = this.dataModel.options[i];
      if (this.value + '' == option.value + '') {
        if (option.text) {
          text += option.text;
        } else {
          text += option.value;
        }
      }
    }
    optionHtml += "<label class=\"tfp-radio-label\" style=\"margin-left:0px;\">" + text + "</label>\r\n";
    return optionHtml;
  }

  addOption(option, isInit, i) {
    let indent = this.getHtmlIndent();
    let str = "";
    if (this.portrait && this._jqObj.children().length > 0 && this.dataModel.showStyle == 'defaultMode')
      str += indent + "\t<br>\r\n";
    str += this.getOptionHtml(indent, option, i);
    if (str != "") {
      if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") {
        this._jqObj.find(".tfp-radio-button").append(str);
        this.bindOptionEvent(this._jqObj.find(".tfp-radio-item").last().get(0));
      } else {
        this._jqObj.append(str);
        this.bindOptionEvent(this._jqObj.find(".tfp-radio-box,.tfp-radio-label").last().get(0));
      }
      if (!isInit) this.dataModel.options.push(option);
    }
  }

  bindOptionEvent(el) {
    let that = this;

    $(el).click(function () {
      if (that.dataModel.disabled || that.dataModel.readonly) return;

      let elHtml = $(el);
      if ($(el).hasClass("tfp-radio-label")) elHtml = $(el).prev();

      let curValue = elHtml.attr("data-option");

      if (that.dataModel.showStyle == "buttonMode" || that.dataModel.showStyle == "disperseMode") {
        $(el).addClass("tfp-radio-item-selected");
        $(el).siblings(".tfp-radio-item").removeClass("tfp-radio-item-selected");
      }
      that.value = curValue;
    });
    /*$(el).next().click(function() {
      if (that.dataModel.disabled || that.dataModel.readonly) return;
      that.value = curValue;
    });*/
  }

  bindOptionsEvent() {
    var that = this;
    if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") {
      this._jqObj.find(".tfp-radio-item").each(function () {
        that.bindOptionEvent(this);
      });
    }
    else {
      this._jqObj.find(".tfp-radio-box,.tfp-radio-label").each(function () {
        that.bindOptionEvent(this);
      });
    }
  }

  /**
   * 检查数据加载参数是否设置正确
   * @returns 
   */
  checkLoadDataArg() {
    if (!this.dataModel.valueField) {
      alert("请为[" + this.id + "]设置选项值字段格式！");
      return false;
    }
    return true;
  }

  bindData(data) {
    if (data.rows && data.rowsCount) {
      data = data.rows;
    }
    if (!Array.isArray(data)) return;
    let options = [];
    for (let i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {
        value: row[this.dataModel.valueField]
      };
      if (this.dataModel.textField) {
        option.text = row[this.dataModel.textField];
      } else {
        option.text = option.value;
      }
      options.push(option);
    }
    this.options = options;
    this.checkOptionByValue();
    this.bindOptionsEvent();
    if (this.dataModel.onBindData) {
      try {
        eval(this.dataModel.onBindData);
      } catch (err) {
        console.log(err);
      }
    }
  }

  initRuntime() {
    let that = this;

    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService
      || (this.dataModel.dataQuerySetting
        && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
      )) {
      this.loadData();
    } else if (this.dataModel.typeCode) {
      this.dataModel.valueField = "code";
      this.dataModel.textField = "name";

      this._tfp.use("Service", function () {
        let service = that._tfp.new("Service");
        service.path = "sys/service/data_dic/getList.tbs";
        service.request({ typeCode: that.dataModel.typeCode }, function (req, res) {
          that.bindData(res.data);
        });
      });
    } else if (this.options && this.options.length > 0) {
      this.bindOptionsEvent();
    }
  }
}