export default {
  "name": "QrCode",
  "comment": "二维码",
  "jsFiles": "qrcode.min.js",
  "attrs": [
    {
      "name": "text",
      "comment": "文本内容",
      "type": "String"
    },
    {
      "name": "width",
      "comment": "宽度",
      "type": "Int",
      "default": 96
    },
    {
      "name": "height",
      "comment": "高度",
      "type": "Int",
      "default": 96
    },
    {
      "name": "colorDark",
      "comment": "前景色",
      "type": "string",
      "default": "#000000"
    },
    {
      "name": "colorLight",
      "comment": "背景色",
      "type": "String",
      "default": "#ffffff"
    }
  ],
  "styles": ["position", "margin", "border", "other"],
  "defaultStyles": {

  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    },
    {
      "name": "onClick",
      "comment": "点击时",
      "isNotHtmlEvent": true
    },
    {
      "name": "onMouseOver",
      "comment": "鼠标经过时",
      "isNotHtmlEvent": true
    },
    {
      "name": "onMouseOut",
      "comment": "鼠标移出时",
      "isNotHtmlEvent": true
    }
  ],
  "methods": [
    {
      "name": "clear",
      "comment": "清除数据"
    },
    {
      "name": "makeCode",
      "comment": "重置数据",
      "args": [
        {
          "name": "text",
          "comment": "文本内容",
          "type": "String",
          "required": true
        }
      ]
    }
  ]
}