import { VisibleComponent } from "../controller.js";

/**
 * 二维码组件
 * @param {[type]} dataModel [description]
 */
export default class QrCode extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "QrCode", dataModel, parent);

    this.qrCode = null;
  }

  get text () { return this.dataModel.text }
  set text (value) {
    this.dataModel.text = value;
    if(value) this.renderQr(value);
  }

  get width () { return this.dataModel.width }
  set width (value) {
    this.dataModel.width = value;
    if (this._jqObj) {
      this._jqObj.css("width", value + "px");
      if(this._tfp.isDesigning) this._jqObj.css("background-size", this.dataModel.width+"px "+this.dataModel.height+"px");
    }
  }

  get height () { return this.dataModel.height }
  set height (value) {
    this.dataModel.height = value;
    if (this._jqObj) {
      this._jqObj.css("height", value + "px");
      if(this._tfp.isDesigning) this._jqObj.css("background-size", this.dataModel.width+"px "+this.dataModel.height+"px");
    }
  }
  get colorDark () { return this.dataModel.colorDark }
  set colorDark (value) {
    this.dataModel.colorDark = value;

  }
  get colorLight () { return this.dataModel.colorLight }
  set colorLight (value) {
    this.dataModel.colorLight = value;

  }

  renderQr(txt) {
    //运行时不生产图片，因为图片无法拖拽调整位置
    if(this._tfp.isDesigning) return;
    this._jqObj.empty();
    this.qrCode = new QRCode(this.el, {
      text: txt,
      width: this.dataModel.width,
      height: this.dataModel.height,
      colorDark: this.dataModel.colorDark,
      colorLight: this.dataModel.colorLight,
      correctLevel: QRCode.CorrectLevel.H
    });
  }

  initDesigning() {
    if(this._jqObj) {
      if(this._jqObj.parent().get(0).tagName=="TD") {
        this._jqObj.css("vertical-align", "middle");
        if(!(this.dataModel.styles && this.dataModel.styles.display)) this._jqObj.css("display", "inline-block");
      }
    }
  }

  /**
   * 初始化运行时
   * @return {[type]} [description]
   */
  initRuntime () {
    this.initDesigning();
    
    let txt = this.dataModel.text;
    if (!txt) txt = "http://www.taskbuilder.org";
    //如果不是动态绑定的后台数据，则初始化时即可渲染，否则需要等绑定数据后再渲染
    if(txt.indexOf("{")<0) this.renderQr(txt);

    var that = this;
    this._jqObj.click(function () {
      if (that.dataModel.onClick) {
        eval(that.dataModel.onClick);
      }
    });
    this._jqObj.mouseover(function () {
      if (that.dataModel.onMouseOver) {
        eval(that.dataModel.onMouseOver);
      }
    });
    this._jqObj.mouseout(function () {
      if (that.dataModel.onMouseOut) {
        eval(that.dataModel.onMouseOut);
      }
    });
  }

  clear () {
    this.qrCode.clear();
  }

  makeCode (e) {
    console.log(e);
    this.qrCode.makeCode(e);
  }

  styleOnChange(styleName, styleValue) {
    if(this._tfp.isDesigning && (styleName=="width" || styleName=="height")) {
      if(styleName=="width") {
        this.width = this._tfp.getPx(styleValue);
      } else if(styleName=="height") {
        this.height = this._tfp.getPx(styleValue);
      }
    }
  }
}