export default {
  "name": "Progress",
  "comment": "进度条",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "组件值",
          "type": "Number",
          "default": 20
        },
        {
          "name": "comment",
          "comment": "组件备注",
          "type": "String"
        },
        {
          "name": "dataType",
          "comment": "进度条当前状态",
          "type": "Select",
          "default": "text",
          "options": [
            {
              "value": "success",
              "text": "成功"
            },
            {
              "value": "warning",
              "text": "警告"
            },
            {
              "value": "exception",
              "text": "异常"
            }
          ]
        },
        {
          "name": "circle",
          "comment": "环形进度条",
          "type": "Switch"
        },
        {
          "name": "diam",
          "comment": "环形直径",
          "type": "String",
          "default": "200"
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "position": "relative",
    "width": "200px",
    "margin-bottom": "15px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    },
    {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }
  ]
}



