import { VisibleComponent } from "../controller.js";

/**
 * 打印报表页码
 * @param {[type]} dataModel [description]
 */
export default class PrintReportPageNumber extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "PrintReportPageNumber", dataModel, parent);
    if(!dataModel.value) dataModel.value = "{页码}";
  }

  //标签值
  get value() {
    if (!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      this._jqObj.html(value);
    }
  }
}