export default {
  "name": "PrintReportPage",
  "comment": "打印报表页",
  "cssFiles": [
    "style.css"
  ],
  "attrs": [
    {
      "name": "pageSetting",
      "comment": "页面设置",
      "type": "group",
      "items": [
        {
          "name": "pageSize",
          "comment": "纸张大小",
          "type": "Select",
          "default": "A4",
          "options": [
            {
              "value": "A3",
              "text": "A3"
            },
            {
              "value": "A4",
              "text": "A4"
            },
            {
              "value": "A5",
              "text": "A5"
            },
            {
              "value": "B4",
              "text": "B4"
            },
            {
              "value": "B5",
              "text": "B5"
            },
            {
              "value": "Custom",
              "text": "自定义"
            }
          ]
        },
        {
          "name": "orientation",
          "comment": "打印方向",
          "type": "Select",
          "default": "portrait",
          "options": [
            {
              "value": "portrait",
              "text": "纵向"
            },
            {
              "value": "landscape",
              "text": "横向"
            }
          ]
        },
        {
          "name": "pageWidth",
          "comment": "自定义页宽(mm)",
          "type": "Int",
          "hidden": "'{pageSize}'!='Custom'"
        },
        {
          "name": "pageHeight",
          "comment": "自定义页高(mm)",
          "type": "Int",
          "hidden": "'{pageSize}'!='Custom'"
        },
        {
          "name": "paddingTop",
          "comment": "上边距(mm)",
          "type": "Int",
          "default": "20"
        },
        {
          "name": "paddingBottom",
          "comment": "下边距(mm)",
          "type": "Int",
          "default": "20"
        },
        {
          "name": "paddingLeft",
          "comment": "左边距(mm)",
          "type": "Int",
          "default": "20"
        },
        {
          "name": "paddingRight",
          "comment": "右边距(mm)",
          "type": "Int",
          "default": "20"
        }]
    },
    {
      "name": "pageHeaderSetting",
      "comment": "页眉设置",
      "type": "group",
      "items": [
        {
          "name": "pageHeaderHeight",
          "comment": "高度(mm)",
          "type": "Int",
          "default": 10
        },
        {
          "name": "pageHeaderHidden",
          "comment": "隐藏",
          "type": "Switch"
        }
      ]
    },
    {
      "name": "reportHeaderSetting",
      "comment": "表头设置",
      "type": "group",
      "items": [
        {
          "name": "reportHeaderDataQuerySetting",
          "comment": "表头数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px",
          "isDataBindSetting": true
        },
        {
          "name": "reportHeaderHeight",
          "comment": "高度(mm)",
          "type": "Int",
          "default": 20
        },
        {
          "name": "reportHeaderDisplay",
          "comment": "显示方式",
          "type": "Select",
          "default": "first",
          "options": [{
            "value": "first",
            "text": "仅在首页显示"
          }, {
            "value": "all",
            "text": "每页都显示"
          }, {
            "value": "none",
            "text": "不显示"
          }]
        }
      ]
    },
    {
      "name": "reportBodySetting",
      "comment": "表体设置",
      "type": "group",
      "items": [
        {
          "name": "reportBodyDataQuerySetting",
          "comment": "表体数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px",
          "isDataBindSetting": true
        }
      ]
    },
    {
      "name": "reportFooterSetting",
      "comment": "表尾设置",
      "type": "group",
      "items": [
        {
          "name": "reportFooterDataQuerySetting",
          "comment": "表尾数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px",
          "isDataBindSetting": true
        },
        {
          "name": "reportFooterHeight",
          "comment": "高度(mm)",
          "type": "Int",
          "default": 20
        },
        {
          "name": "reportFooterDisplay",
          "comment": "显示方式",
          "type": "Select",
          "default": "last",
          "options": [{
            "value": "last",
            "text": "仅在尾页显示"
          }, {
            "value": "all",
            "text": "每页都显示"
          }, {
            "value": "none",
            "text": "不显示"
          }]
        }
      ]
    },
    {
      "name": "pageFooterSetting",
      "comment": "页脚设置",
      "type": "group",
      "items": [
        {
          "name": "pageFooterHeight",
          "comment": "高度(mm)",
          "type": "Int",
          "default": 10
        },
        {
          "name": "pageFooterHidden",
          "comment": "隐藏",
          "type": "Switch"
        }
      ]
    }
  ],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "position": "absolue",
    "z-index": 1,
    "left": "10px",
    "top": "10px",
    "right": "10px",
    "bottom": "10px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }
  ]
}