import TFPComponentRender from '../render.js'

export default class PreRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    if (!this._tfp.isDesigning) {
      return "{{" + this.dataModel.id + "}}";
    }
    else {
      if (this.dataModel.value) return this.dataModel.value;
      if (this.dataModel.dataBindingFormat) return this.dataModel.dataBindingFormat;
    }
    return "";
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }

    if (this.dataModel.dataBindingFormat) {
      if (otherOptions && otherOptions.gridContainer)
        cpt_wx.wxml = "{{item." + this.dataModel.id + "}}";
      else
        cpt_wx.wxml = "{{" + this.dataModel.id + "}}";
    }
    else if (this.dataModel.value) cpt_wx.wxml = this.dataModel.value;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("pre", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", false, parentIndent, retainStyleAttr, otherOptions);
  }
}