import {VisibleComponent} from "../controller.js";

/**
 * 文本段落组件
 * @param {[type]} dataModel [description]
 */
export default class Pre extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Pre", dataModel, parent);
  }

  //标签值
  get value() { 
    if(!this.dataModel.value) return "";
    return this.dataModel.value; 
  }
  set value(value) {
    this.dataModel.value = value;
    if(this._jqObj) {
      this._jqObj.html(value);
      this.exeEventHandler("onChange");
    }
  }

  //数据绑定格式
  get dataBindingFormat() { return this.dataModel.dataBindingFormat }
  set dataBindingFormat(value) {this.dataModel.dataBindingFormat = value}
  
}