import TFPComponentRender from '../render.js'

export default class PopupSelectionRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml = function (getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let pla = "";
    if (this.dataModel.placeHolder) pla = this.dataModel.placeHolder;
    let iptWidth = "calc(100% - 30px)";
    if (!this.dataModel.showIcon && !this._tfp.isDesigning) iptWidth = "calc(100% - 5px)";

    html += indent + "\t<input type=\"text\" readonly placeholder=\"" + pla + "\" style=\"width:" + iptWidth + "\"/>\r\n";
    if (this.cpt.showIcon) html += indent + "\t<img src=\"" + this.cpt.iconUrl + "\" />\r\n";
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}