import { FormInput } from "../controller.js";

/**
 * 弹窗选择组件
 * @param {[type]} dataModel [description]
 */
export default class PopupSelection extends FormInput {

  constructor(__tfp, dataModel, parent, inputType) {
    if (inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "PopupSelection", dataModel, parent);
    }
  }

  get value() {
    if (this._jqObj && this._jqObj.find("input").val() == "") {
      this.dataModel.value = '';
    }
    return this.dataModel.value;
  }
  set value(value) {
    let val = value;
    if (this._tfp.isNull(val)) {
      val = '';
      this.dataModel.value = '';
      this._jqObj.find("input").val('');
    }

    if (val) {
      if (!$.isPlainObject(val)) {
        val = {
          value: val,
          text: val
        };
      } else {
        if (!val.value || !val.text)
          val = {
            value: val["" + this.dataModel.dialogPageSetting.value + ""],
            text: val["" + this.dataModel.dialogPageSetting.text + ""]
          };
      }

      if (this.dataModel.valueType == 'value') {
        this.dataModel.value = val.value;
      } else if (this.dataModel.valueType == 'text') {
        this.dataModel.value = val.text;
      } else {
        this.dataModel.value = val;
      }

      this._jqObj.find("input").val(val.text);
    }

    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      if (this.dataModel["onChange"]) eval(this.dataModel["onChange"]);
    }
  }

  get placeHolder() { return this.dataModel.placeHolder }
  set placeHolder(value) {
    this.dataModel.placeHolder = value;
    this._jqObj.find("input").attr("placeholder", value);
  }

  get iconUrl() {
    return this._tfp.rootPath + "/src/components/"
      + this.dataModel.type.toLowerCase() + "/images/icon.png";
  }
  set iconUrl(value) { }

  //数据绑定格式
  get dataBindingFormat() { return this.dataModel.dataBindingFormat }
  set dataBindingFormat(value) { this.dataModel.dataBindingFormat = value }

  get valueType() { return this.dataModel.valueType ? this.dataModel.valueType : "" }
  set valueType(value) {
    if (!this.checkAttrOption("valueType", value)) {
      this._tfp.showMsg("不支持类型：" + value + "！");
      return;
    }
    this.dataModel.valueType = value;
  }

  get showIcon() { return this.dataModel.showIcon }
  set showIcon(value) {
    this.dataModel.showIcon = value ? true : false;
    if (this._jqObj) {
      if (this.dataModel.showIcon) {
        if (this._jqObj.find("img").length == 0) {
          this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
        }
      } else {
        this._jqObj.find("img").remove();
      }
      let iptWidth = "calc(100% - 5px)";
      if (this.dataModel.showIcon) iptWidth = "calc(100% - 30px)";
      this._jqObj.find("input").css("width", iptWidth + "px");
    }
  }


  get dialogPageSetting() { return this.dataModel.dialogPageSetting }
  set dialogPageSetting(value) {
    this.dataModel.dialogPageSetting = value
  }

  showPicker(cb) {
    if (!this.dataModel.dialogPageSetting) return;
    let dialogPageSetting = this.dataModel.dialogPageSetting;
    let tmpPath = dialogPageSetting.path;
    if (tmpPath.startsWith("/web/")) {
      tmpPath = tmpPath.substr(4);
    }
    this._tfp.openDialog("选择数据", tmpPath, dialogPageSetting.width + 'px', dialogPageSetting.height + 'px', null, function (ret) {
      dialogPageSetting.options.forEach(element => {
        tfp.get(element.id).value = ret["" + element.field + ""];
      });
      let value = {
        value: ret["" + dialogPageSetting.value + ""],
        text: ret["" + dialogPageSetting.text + ""],
      }
      cb(value);
    });
  }

  initRuntime() {
    let that = this;

    if (this.readonly) {
      this._jqObj.find("input").css({ "margin-left": "0px", "padding-left": "0px" });
    }

    this._jqObj.click(function () {
      if (that.readonly || that.disabled) return;
      that.showPicker(function (ret) {
        that.value = ret;
      });
    });

    this._jqObj.hover(function () {
      if(that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light") {
        that._jqObj.css("background-color", "#F6F6F6");
        that._jqObj.find("input").css("background-color", "#F6F6F6");
      }
    }, function () {
      if(that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light" && !that._jqObj.find("input").is(":focus")) {
        that._jqObj.css("background-color", "");
        that._jqObj.find("input").css("background-color", "");
      }
    });

    this._jqObj.find("input").focus(function () {
      if (that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light") 
        that._jqObj.css("outline", "1px solid var(--sys-theme-color)");
      try {
        if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
      } catch (err) {
        console.log(err.message);
      }
    });

    this._jqObj.find("input").blur(function () {
      if (that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light") {
        that._jqObj.css("outline", "0");
        that._jqObj.css("background-color", "");
        that._jqObj.find("input").css("background-color", "");
      }
      try {
        if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
      } catch (err) {
        console.log(err.message);
      }
    });
  }
}