import TFPComponentRender from '../render.js'

export default class PopupListRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let indent = this.getHtmlIndent();
    let placeHolders = '';
    if (this.dataModel.placeHolders) placeHolders = this.dataModel.placeHolders;
    let text = '';
    if (this.dataModel.options && this.dataModel.value) {
      for (var i = 0; i < this.dataModel.options.length; i++) {
        var option = this.dataModel.options[i];
        if ((option.value + "") == (this.dataModel.value + "")) {
          text = option.text;
          break;
        }
      }
    }
    let bodyHtml = "\r\n" + indent + "\t<input type=\"text\" readonly placeholder=\"" + placeHolders + "\"  value=\"" + text + "\" />\r\n";
    bodyHtml += indent + "\t<img src=\"" + this._tfp.rootPath
      + "/src/components/select/images/arrow-down-"
      + this._tfp.curPage.contentColorMode + ".png\" />\r\n"
    return bodyHtml + "\t";
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}