export default {
  "name": "PopupList",
  "comment": "弹出列表",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "组件值",
          "type": "String",
          "isHtmlAttr": true
        },
        {
          "name": "comment",
          "comment": "组件备注",
          "type": "String"
        },
        {
          "name": "options",
          "comment": "选项",
          "type": "Dataset"
        },
        {
          "name": "placeHolders",
          "comment": "输入提示",
          "type": "String"
        },
        {
          "name": "dataBindingFormat",
          "comment": "组件值数据绑定格式",
          "type": "String"
        },
        {
          "name": "textBindingFormat",
          "comment": "组件文本数据绑定格式",
          "type": "String"
        },
        {
          "name": "valueType",
          "comment": "值类型",
          "type": "Select",
          "options": [
            { "value": "value", "text": "参数值" },
            { "value": "text", "text": "参数文本" },
            { "value": "obj", "text": "参数对象" }
          ],
          "default": "value",
          "notnull": true
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "multiCheck",
          "comment": "允许多选",
          "type": "Switch"
        },
        {
          "name": "enableFilter",
          "comment": "启用智能筛选",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "filterArgName",
          "comment": "筛选时传给后台的参数名",
          "type": "String",
          "default": "keyword"
        }
      ]
    },
    {
      "name": "dataSourceSetting",
      "comment": "数据源设置",
      "type": "group",
      "items": [
        {
          "name": "dataQuerySetting",
          "comment": "数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px"
        },
        {
          "name": "dataListValueFormat",
          "comment": "选项值数据格式",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "dataListTextFormat",
          "comment": "选项文本数据格式",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "dataListDivWidth",
          "comment": "可选项列表宽度",
          "type": "Int"
        },
        {
          "name": "dataListDivHeight",
          "comment": "可选项列表高度",
          "type": "Int",
          "default": "240"
        },
        {
          "name": "showTable",
          "comment": "显示多列表格",
          "type": "Switch"
        },
        {
          "name": "showRowNum",
          "comment": "显示序号",
          "type": "Switch"
        },
        {
          "name": "allowPaging",
          "comment": "允许翻页",
          "type": "Switch"
        },
        {
          "name": "pageSize",
          "comment": "每页显示数量",
          "type": "Select",
          "options": [
            {
              "value": "20",
              "text": "20"
            },
            {
              "value": "30",
              "text": "30"
            },
            {
              "value": "50",
              "text": "50"
            },
            {
              "value": "100",
              "text": "100"
            },
            {
              "value": "200",
              "text": "200"
            },
            {
              "value": "300",
              "text": "300"
            },
            {
              "value": "500",
              "text": "500"
            }
          ]
        },
        {
          "name": "rowHeight",
          "comment": "行高",
          "type": "Number",
          "default": "45"
        },
        {
          "name": "columns",
          "comment": "表格列设置",
          "type": "DataSet",
          "isPro": true,
          "keyCol": "id",
          "width": "640px",
          "height": "600px",
          "columns": [
            {
              "id": "name",
              "name": "列标题",
              "type": "String"
            },
            {
              "id": "width",
              "name": "宽度",
              "type": "Size"
            },
            {
              "id": "fill",
              "name": "宽度弹性伸缩",
              "type": "Switch"
            },
            {
              "id": "fixed",
              "name": "固定在列表左侧",
              "type": "Switch"
            },
            {
              "id": "fixedOnRight",
              "name": "固定在列表右侧",
              "type": "Switch"
            },
            {
              "id": "bold",
              "name": "文字加粗",
              "type": "Switch"
            },
            {
              "id": "color",
              "name": "文字颜色",
              "type": "Color"
            },
            {
              "id": "align",
              "name": "水平对齐方式",
              "type": "Select",
              "default": "center",
              "options": [
                {
                  "value": "left",
                  "text": "左对齐"
                },
                {
                  "value": "center",
                  "text": "居中对齐"
                },
                {
                  "value": "right",
                  "text": "右对齐"
                }
              ]
            },
            {
              "id": "dataFormat",
              "name": "内容格式",
              "type": "Select",
              "default": "text",
              "options": [
                {
                  "value": "text",
                  "text": "文本"
                },
                {
                  "value": "int",
                  "text": "整数"
                },
                {
                  "value": "decimal",
                  "text": "小数"
                },
                {
                  "value": "filesize",
                  "text": "文件大小：xxxKB,xxxMB,xxxGB,xxxTB"
                },
                {
                  "value": "money|0.00",
                  "text": "金额：0.00"
                },
                {
                  "value": "money|0,000.00",
                  "text": "金额：0,000.00"
                },
                {
                  "value": "week",
                  "text": "星期：X"
                },
                {
                  "value": "week|星期",
                  "text": "星期：星期X"
                },
                {
                  "value": "date|yyyy",
                  "text": "年份：yyyy"
                },
                {
                  "value": "date|MM",
                  "text": "月份：MM"
                },
                {
                  "value": "date|yyyy-MM",
                  "text": "年月：yyyy-MM"
                },
                {
                  "value": "date|yyyy/MM",
                  "text": "年月：yyyy/MM"
                },
                {
                  "value": "date|yyyy-MM-dd",
                  "text": "日期：yyyy-MM-dd"
                },
                {
                  "value": "date|yyyy/MM/dd",
                  "text": "日期：yyyy/MM/dd"
                },
                {
                  "value": "date|yyyy年MM月dd日",
                  "text": "日期：yyyy年MM月dd日"
                },
                {
                  "value": "date|MM-dd",
                  "text": "日期：MM-dd"
                },
                {
                  "value": "date|MM/dd",
                  "text": "日期：MM/dd"
                },
                {
                  "value": "date|MM月dd日",
                  "text": "日期：MM月dd日"
                },
                {
                  "value": "date|dd",
                  "text": "日期：dd"
                },
                {
                  "value": "time|HH:mm",
                  "text": "时间：HH:mm"
                },
                {
                  "value": "time|HH:mm:ss",
                  "text": "时间：HH:mm:ss"
                },
                {
                  "value": "time|HH时mm分",
                  "text": "时间：HH时mm分"
                },
                {
                  "value": "time|HH时mm分ss秒",
                  "text": "时间：HH时mm分ss秒"
                },
                {
                  "value": "datetime|yyyy-MM-dd HH:mm",
                  "text": "日期时间：yyyy-MM-dd HH:mm"
                },
                {
                  "value": "datetime|yyyy-MM-dd HH:mm:ss",
                  "text": "日期时间：yyyy-MM-dd HH:mm:ss"
                },
                {
                  "value": "datetime|yyyy/MM/dd HH:mm",
                  "text": "日期时间：yyyy/MM/dd HH:mm"
                },
                {
                  "value": "datetime|yyyy/MM/dd HH:mm:ss",
                  "text": "日期时间：yyyy/MM/dd HH:mm:ss"
                },
                {
                  "value": "datetime|yyyy年MM月dd日 HH:mm",
                  "text": "日期时间：yyyy年MM月dd日 HH:mm"
                },
                {
                  "value": "datetime|yyyy年MM月dd日 HH:mm:ss",
                  "text": "日期时间：yyyy年MM月dd日 HH:mm:ss"
                },
                {
                  "value": "datetime|yyyy年MM月dd日 HH时mm分",
                  "text": "日期时间：yyyy年MM月dd日 HH时mm分"
                },
                {
                  "value": "datetime|yyyy年MM月dd日 HH时mm分ss秒",
                  "text": "日期时间：yyyy年MM月dd日 HH时mm分ss秒"
                }
              ]
            },
            {
              "id": "decimalCalcReg",
              "name": "小数取值规则",
              "type": "Select",
              "default": "",
              "options": [
                {
                  "value": "",
                  "text": "不处理"
                },
                {
                  "value": "trunc",
                  "text": "取整"
                },
                {
                  "value": "round",
                  "text": "四舍五入"
                },
                {
                  "value": "ceil",
                  "text": "向上取整"
                },
                {
                  "value": "floor",
                  "text": "向下取整"
                },
                {
                  "value": "toFixed",
                  "text": "固定精度"
                },
                {
                  "value": "toPrecision",
                  "text": "固定长度"
                },
                {
                  "value": "abs",
                  "text": "求绝对值"
                }
              ]
            },
            {
              "id": "decimalLength",
              "name": "小数位数",
              "type": "Number"
            },
            {
              "id": "format",
              "name": "数据绑定表达式",
              "type": "String",
              "wrap": true
            },
            {
              "id": "class",
              "name": "CSS样式class",
              "type": "String",
              "wrap": true
            },
            {
              "id": "style",
              "name": "自定义CSS样式",
              "type": "String",
              "wrap": true
            }
          ]
        },
        {
          "name": "inputs",
          "comment": "关联输入项",
          "type": "Dataset",
          "columns": [
            {
              "id": "inputId",
              "name": "输入项编号",
              "type": "String",
              "width": "150px",
              "required": true
            },
            {
              "id": "fieldName",
              "name": "字段名",
              "type": "String",
              "width": "360px",
              "required": true
            }
          ]
        }
      ]
    },
    {
      "name": "treeSetting",
      "comment": "树形显示设置",
      "type": "group",
      "items": [
        {
          "name": "showTree",
          "comment": "支持树形显示",
          "type": "Switch"
        },
        {
          "name": "expandAllNode",
          "comment": "默认展开全部节点",
          "type": "Switch",
          "default": true
        },
        {
          "name": "parentNodeIdField",
          "comment": "保存父节点ID值的字段名",
          "type": "String",
          "default": "parent_id"
        },
        {
          "name": "rootNodeId",
          "comment": "根节点的ID值",
          "type": "String",
          "default": "0"
        },
        {
          "name": "onlyCanSelectFinalNode",
          "comment": "只能选择末级节点",
          "type": "Switch",
          "default": true
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "120px",
    "height": "30px",
    "line-height": "30px",
    "padding-left": "2px",
    "padding-right": "2px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    },
    {
      "name": "onBeforeLoadData",
      "comment": "加载数据前",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "args",
        "type": "Object",
        "comment": "请求数据"
      }]
    },
    {
      "name": "onAfterLoadData",
      "comment": "加载数据后",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "req",
        "type": "Object",
        "comment": "请求数据"
      }, {
        "name": "res",
        "type": "Object",
        "comment": "响应数据"
      }]
    },
    {
      "name": "onBeforeBindData",
      "comment": "绑定数据前",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "data",
        "type": "Object",
        "comment": "绑定的数据"
      }]
    },
    {
      "name": "onAfterBindData",
      "comment": "绑定数据后",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "data",
        "type": "Object",
        "comment": "绑定的数据"
      }]
    },
    {
      "name": "onClick",
      "comment": "点击时",
      "isNotHtmlEvent": true
    },
    {
      "name": "onFocus",
      "comment": "获得焦点时",
      "isNotHtmlEvent": true
    },
    {
      "name": "onBlur",
      "comment": "失去焦点时",
      "isNotHtmlEvent": true
    },
    {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }],
  "methods": [{
    "name": "bindData",
    "comment": "绑定数据",
    "args": [{
      "name": "data",
      "comment": "数据",
      "type": "Array"
    }]
  }, {
    "name": "getOption",
    "comment": "获得指定索引的选项",
    "args": [{
      "name": "index",
      "comment": "选项索引",
      "type": "Int"
    }]
  }, {
    "name": "getOptionByValue",
    "comment": "获得指定值的选项",
    "args": [{
      "name": "val",
      "comment": "选项值",
      "type": "String"
    }]
  }, {
    "name": "loadData",
    "comment": "加载数据",
    "args": []
  }, {
    "name": "setOptions",
    "comment": "设置可选项",
    "args": [{
      "name": "options",
      "comment": "可选项",
      "type": "String"
    }]
  }, {
    "name": "showOptions",
    "comment": "显示选项列表",
    "args": []
  }]
}