function PopupList() {

  this.lists = null;
  this.cb = null;
  this.touchStartInfo = null;

  this.show = function (lists, cb) {
    this.lists = lists;
    if (cb) this.cb = cb;
    $("body").append("<div class=\"tfp-mask-div\"></div>");
    $("body").append("<div class=\"tfp-popuplist\">"
      + "<div class=\"tfp-popuplist-content\"></div>"
      + "<div class=\"tfp-popuplist-touch\"></div>"
      + "<div class=\"tfp-popuplist-bottom\">"
      + "  <div onclick =\"window.popupList.clear()\">清空</div>"
      + "  <div onclick =\"window.popupList.onOk()\">确定</div>"
      + "  <div onclick =\"window.popupList.close()\">取消</div>"
      + "</div>"
      + "</div>");

    for (var i = 0; i < lists.length; i++) {
      var list = lists[i];
      let width = "100%";
      if (list.width) width = list.width;
      var listHtml = "<div class=\"tfp-popuplist-content-column\" "
        + "style=\"width:" + width + "; background-color: " + list.bgColor + ";\">"
        + "<div class=\"tfp-popuplist-content-items\">";
      let valOptionIndex = 0;
      if (list.options) {
        //上面加三个空白的选项，以便可以滚动显示第一条记录
        listHtml += "<div class=\"tfp-popuplist-content-item\" data-value=\"\"></div>";
        listHtml += "<div class=\"tfp-popuplist-content-item\" data-value=\"\"></div>";
        listHtml += "<div class=\"tfp-popuplist-content-item\" data-value=\"\"></div>";
        for (var j = 0; j < list.options.length; j++) {
          let option = list.options[j];
          if (typeof (option) == "string") {
            option = {
              value: option,
              text: option
            };
          }
          if (option.value == list.value) valOptionIndex = j;
          let text = option.value;
          if (option.text) text = option.text;
          listHtml += "<div class=\"tfp-popuplist-content-item\" data-value=\""
            + option.value + "\">" + text + "</div>";
        }
        //下面加三个空白的选项，以便可以滚动显示最后一条记录
        listHtml += "<div class=\"tfp-popuplist-content-item\" data-value=\"\"></div>";
        listHtml += "<div class=\"tfp-popuplist-content-item\" data-value=\"\"></div>";
        listHtml += "<div class=\"tfp-popuplist-content-item\" data-value=\"\"></div>";
      }
      listHtml += "</div></div>";
      $(".tfp-popuplist-content").append(listHtml);
      if (valOptionIndex > 0) $(".tfp-popuplist-content-column").get(i).scrollTop = valOptionIndex * 40;
    }
    for (var i = 0; i < 7; i++) {
      let style = "";
      if (i == 3) {
        style = "background:transparent;border-top: 1px solid #eeeeee;"
          + "border-bottom: 1px solid #eeeeee;";
      } else {
        style = "background-color: #FFFFFF; opacity:";
        if (i == 0 || i == 6) style += "0.9";
        if (i == 1 || i == 5) style += "0.6";
        if (i == 2 || i == 4) style += "0.3";
        style += ";";
      }
      style += "top:" + (i * 40 + 10) + "px;";
      $(".tfp-popuplist").append("<div class=\"tfp-popuplist-mask\" style=\"" + style + "\"></div>");
    }
    let that = this;
    let touchDiv = $(".tfp-popuplist-touch").get(0);
    touchDiv.addEventListener("touchstart", function (event) {
      that.onTouchStart(event);
    });
  }

  this.onTouchStart = function (event) {
    var touch = event.targetTouches[0]; //touches数组对象获得屏幕上所有的touch，取第一个touch
    this.touchStartInfo = {
      x: touch.pageX,
      y: touch.pageY
    };  //取第一个touch的坐标值
    for (var i = 0; i < $(".tfp-popuplist-content-column").length; i++) {
      let divTmp = $($(".tfp-popuplist-content-column").get(i));
      if (touch.pageX > divTmp.offset().left && touch.pageX < (divTmp.offset().left + divTmp.width())) {
        this.touchStartInfo.columnIndex = i;
        this.touchStartInfo.contentDiv = divTmp.get(0);
        this.touchStartInfo.scrollTop = divTmp.get(0).scrollTop;
        break;
      }
    }
    if (!this.touchStartInfo.contentDiv) return;
    let that = this;
    let touchDiv = $(".tfp-popuplist-touch").get(0);
    touchDiv.addEventListener("touchmove", function (event) {
      that.onTouchMove(event);
    });
    touchDiv.addEventListener("touchend", function (event) {
      that.onTouchEnd(event);
    });
  }

  this.onTouchMove = function (event) {
    //当屏幕有多个touch或者页面被缩放过，就不执行move操作
    if (event.targetTouches.length > 1 || event.scale && event.scale !== 1) return;
    var touch = event.targetTouches[0];
    let endPos = {
      x: touch.pageX - this.touchStartInfo.x,
      y: touch.pageY - this.touchStartInfo.y
    };
    let touchType = Math.abs(endPos.x) < Math.abs(endPos.y) ? 1 : 0; //touchType为1时，表示纵向滑动，0为横向滑动
    if (touchType === 1) {
      event.preventDefault(); //阻止触摸事件的默认行为，即阻止滚屏
      this.touchStartInfo.contentDiv.scrollTop = this.touchStartInfo.scrollTop - endPos.y;
    }
  }

  this.onTouchEnd = function (event) {
    let touchDiv = $(".tfp-popuplist-touch").get(0);
    touchDiv.removeEventListener('touchmove', this.onTouchMove);
    touchDiv.removeEventListener('touchend', this.onTouchEnd);
    let contentDiv = this.touchStartInfo.contentDiv;
    let interval = 40 - contentDiv.scrollTop % 40;
    if (interval <= 20) {
      contentDiv.scrollTop = contentDiv.scrollTop + interval;
    } else {
      contentDiv.scrollTop = contentDiv.scrollTop - contentDiv.scrollTop % 40;
    }
    let list = this.lists[this.touchStartInfo.columnIndex];
    if (list.onChange) list.onChange();
  }

  this.getColumnVal = function (colIndex) {
    let column = $(".tfp-popuplist-content-column").get(colIndex);
    let centerMaskDivOffset = $($(".tfp-popuplist-mask").get(3)).offset();
    let itemIndex = column.scrollTop / 40 + 3;
    let items = $(column).find(".tfp-popuplist-content-item");
    let curItemCenterY = $(items.get(itemIndex)).offset().top + 20;
    let upperItemCenterY = curItemCenterY - 40;
    let belowItemCenterY = curItemCenterY + 40;
    let item = items.get(itemIndex);
    if (upperItemCenterY > centerMaskDivOffset.top && upperItemCenterY < (centerMaskDivOffset.top + 40)) {
      items.get(itemIndex - 1);
    } else if (belowItemCenterY > centerMaskDivOffset.top && belowItemCenterY < (centerMaskDivOffset.top + 40)) {
      items.get(itemIndex + 1)
    }
    return $(item).attr("data-value");
  }

  this.clear = function () {
    let values = [];
    this.cb(values);
    this.close();
  }

  this.onOk = function () {
    try {
      if (this.cb) {
        let values = [];
        let columns = $(".tfp-popuplist-content-column");
        let centerMaskDivOffset = $($(".tfp-popuplist-mask").get(3)).offset();
        for (var i = 0; i < columns.length; i++) {
          values.push(this.getColumnVal(i));
        }
        this.cb(values);
      }
      this.close();
    } catch(err) {
      alert(err.message);
    }
  }

  this.close = function () {
    $(".tfp-mask-div").remove();
    $(".tfp-popuplist").remove();
    this.lists = null;
    this.cb = null;
    this.touchStartInfo = null;
  }
}

window.popupList = new PopupList();