import { FormInput } from "../controller.js";

/**
 * 弹出列表组件
 * @param {[type]} dataModel [description]
 */
export default class PopupList extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "PopupList", dataModel, parent);
    this.selectedIndex = 0;
  }

  get value() {
    //如果组件值为空，但组件的输入项里有数据，则用输入项的数据作为组件的值
    if(this._tfp.isNull(this.dataModel.value) && this._jqObj && !isNull(this._jqObj.find("input").val())) {
      let val = this._jqObj.find("input").val().trim();
      if(this.options) {
        for (var i = 0; i < this.options.length; i++) {
          if (this.options[i].text == val) {
            this.dataModel.value = this.options[i].value;
            return this.dataModel.value;
          }
        }
      }
      this.dataModel.value = "";
      return "";
    }
    if (!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value(value) {
    let val = value;
    if (isNull(value)) {
      val = "";
      this.dataModel.value = null;
      //如果是可编辑表格里的弹出列表
      if(this.dataModel.dataSet) {
        let dataSet = tfp.get(this.dataModel.dataSet);
        if(dataSet) {
          let rowIndex = this._jqObj.parent().index();
          let colIndex = this._jqObj.index();
          if(dataSet.showCheckbox) colIndex--;
          if(dataSet.showRowNum) colIndex--;
          //如果设置了关联输入项，则当前组件的值为空，则同步清空关联输入项的值
          this.clearRelationDataSetInput(dataSet, rowIndex, colIndex);
        }
      }
      //if (this.dataModel.multiCheck) this.showOptions();
    } else {
      if (!this.dataModel.multiCheck) {
        let obj = {};
        let value = val;
        let text = '';
        if (this.dataModel.options) {
          for (var i = 0; i < this.dataModel.options.length; i++) {
            let option = this.dataModel.options[i];
            if ((option.value + "") == (val + "")) {
              this._jqObj.find("input").val(option.text);
              obj = option;
              if (option.text) text = option.text;
              break;
            }
          }
        }
        if (this.dataModel.valueType == "obj") {
          this.dataModel.value = obj;
        } else if (this.dataModel.valueType == "text") {
          this.dataModel.value = text;
        } else {
          this.dataModel.value = value;
        }
      }
      else this.dataModel.value = val;
    }
    if (this._jqObj) {
      if (isNull(value)) {
        this._jqObj.find("input").val("");
      } else {
        if (this.dataModel.options) {
          let vals = [];
          let texts = "";
          if(this.dataModel.multiCheck) {
            if(Array.isArray(value)) {
              vals = value;
            } else if(typeof(value)=="string") {
              vals = value.split(",");
            }
          }
          for (var i = 0; i < this.dataModel.options.length; i++) {
            var option = this.dataModel.options[i];
            let text = option.value;
            if(!this._tfp.isNull(option.text)) text = option.text;
            if(this.dataModel.multiCheck) {
              if(vals.includes(option.value)) texts += (texts=="" ? "" : ",") + text;
            } else {
              if ((option.value + "") == (val + "")) {
                this._jqObj.find("input").val(text);
                break;
              }
            }
          }
          if (texts != "") {
            this._jqObj.find("input").val(texts);
          }
        }
      }
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", val);
    }
  }

  get text() {
    if (!this.dataModel.value) return "";
    let item = this.dataModel.options.find(v => v.value == this.dataModel.value);
    if (!item) return "";
    return item.text;
  }
  set text(txt) {
    //
  }

  //数据绑定格式
  get textBindingFormat() { return this.dataModel.textBindingFormat }
  set textBindingFormat(value) { 
    this.dataModel.textBindingFormat = value;
    if (this._jqObj) {
      this._jqObj.find("input").val(value);
    }
  }

  get multiCheck() { return this.dataModel.multiCheck }
  set multiCheck(value) {
    this.dataModel.multiCheck = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get valueType() { return this.dataModel.valueType }
  set valueType(value) {
    if (!this.checkAttrOption("valueType", value)) {
      this._tfp.showMsg("不支持类型：" + value + "！");
      return;
    }
    this.dataModel.valueType = value;
  }

  get options() { return this.dataModel.options }
  set options(value) {
    //if(this._tfp.isDesigning) {
    this.dataModel.options = value;
    return;
    //}
    /*if(this._jqObj && value && Array.isArray(value)) {
      this._jqObj.empty();
      this.dataModel.options = [];
      for(var i=0;i<value.length;i++) {
        this.addOption(value[i]);
      }
      //TODO 如果重置选项列表后，没有组件当前值对应的选项，应该把组件值设置为空
    }*/
  }

  get placeHolders() { return this.dataModel.placeHolders }
  set placeHolders(value) {
    this.dataModel.placeHolders = value;
    if (this._jqObj) this._jqObj.find("input").attr("placeholder", value);
  }

  get loadDataListService() { return this.dataModel.loadDataListService }
  set loadDataListService(value) {
    this.dataModel.loadDataListService = value;
  }

  get dataListBindingMember() { return this.dataModel.dataListBindingMember }
  set dataListBindingMember(value) {
    this.dataModel.dataListBindingMember = value;
  }

  get dataListValueFormat() { return this.dataModel.dataListValueFormat }
  set dataListValueFormat(value) {
    this.dataModel.dataListValueFormat = value;
  }

  get dataListTextFormat() { return this.dataModel.dataListTextFormat }
  set dataListTextFormat(value) {
    this.dataModel.dataListTextFormat = value;
  }

  get dataListDivWidth() { return this.dataModel.dataListDivWidth }
  set dataListDivWidth(value) {
    this.dataModel.dataListDivWidth = value;
  }

  get dataListDivHeight() { return this.dataModel.dataListDivHeight }
  set dataListDivHeight(value) {
    this.dataModel.dataListDivHeight = value;
  }

  get enableFilter() { return this.dataModel.enableFilter }
  set enableFilter(value) {
    this.dataModel.enableFilter = value;
  }

  get filterArgName() { return this.dataModel.filterArgName }
  set filterArgName(value) {
    this.dataModel.filterArgName = value;
  }

  get showTable() {
    return this.dataModel.showTable ? true : false;
  }
  set showTable(value) {
    this.dataModel.showTable = value ? true : false;
  }

  get showRowNum() {
    return this.dataModel.showRowNum ? true : false;
  }
  set showRowNum(value) {
    this.dataModel.showRowNum = value ? true : false;
  }

  get rowHeight() {
    return this.dataModel.rowHeight ? this.dataModel.rowHeight : 40;
  }
  set rowHeight(value) {
    this.dataModel.rowHeight = value;
  }

  get columns() {
    return this.dataModel.columns;
  }
  set columns(value) {
    this.dataModel.columns = value;
  }

  get inputs() {
    return this.dataModel.inputs;
  }
  set inputs(value) {
    this.dataModel.inputs = value;
  }

  get allowPaging() {
    return this.dataModel.allowPaging ? true : false;
  }
  set allowPaging(value) {
    this.dataModel.allowPaging = value ? true : false;
    if (this._tfp.curPage.dataModel.cptDataBindSetting) {
      let dataBindSetting = this._tfp.curPage.dataModel.cptDataBindSetting[this.id];
      if (dataBindSetting && dataBindSetting.dataQuerySetting) {
        dataBindSetting.dataQuerySetting.enableDataPage = this.dataModel.allowPaging;
      }
    }
  }

  get pageSize() {
    return this.dataModel.pageSize ? this.dataModel.pageSize : 20
  }
  set pageSize(value) {
    this.dataModel.pageSize = value ? value : 20
  }

  /*******************  树形显示设置  *******************/

  get showTree() {
    return this.dataModel.showTree ? true : false;
  }
  set showTree(value) {
    this.dataModel.showTree = value ? true : false;
  }

  get expandAllNode() {
    return this.dataModel.expandAllNode ? true : false;
  }
  set expandAllNode(value) {
    this.dataModel.expandAllNode = value ? true : false;
  }

  get parentNodeIdField() {
    return this.dataModel.parentNodeIdField
  }
  set parentNodeIdField(value) {
    this.dataModel.parentNodeIdField = value;
  }

  get rootNodeId() {
    return this.dataModel.rootNodeId
  }
  set rootNodeId(value) {
    this.dataModel.rootNodeId = value;
  }

  get onlyCanSelectFinalNode() {
    return this.dataModel.onlyCanSelectFinalNode ? true : false;
  }
  set onlyCanSelectFinalNode(value) {
    this.dataModel.onlyCanSelectFinalNode = value ? true : false;
  }

  getOption(index) {
    return this.dataModel.options[index];
  }

  getOptionByValue(val) {
    return this.dataModel.options.find(v => v.value == val);
  }

  bindData(data) {
    if (isNull(data) || !Array.isArray(data)) return;
    this.options = [];
    this.nodes = {};
    this.rootNodes = [];

    if (this.dataModel.onBeforeBindData) {
      try {
        eval(this.dataModel.onBeforeBindData);
      } catch (err) {
        console.log(err);
      }
    }

    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {
        data: row
      };
      try {
        let valueFormat = this.dataModel.dataListValueFormat;
        if (valueFormat.indexOf("{") < 0 && valueFormat.indexOf("#[") < 0) valueFormat = "{" + valueFormat + "}";
        option.value = this._tfp.replaceDataField(row, valueFormat);
        if (option.value) option.value = this._tfp.exeExpress(option.value);
      } catch (e) {
        console.log(e);
        return;
      }
      if (isNull(option.value)) continue;
      option.text = option.value;
      if (this.dataModel.dataListTextFormat) {
        try {
          let textFormat = this.dataModel.dataListTextFormat;
          if (textFormat.indexOf("{") < 0 && textFormat.indexOf("#[") < 0) textFormat = "{" + textFormat + "}";
          option.text = this._tfp.replaceDataField(row, textFormat);
          if (option.text) option.text = this._tfp.exeExpress(option.text);
        } catch (e) {
          console.log(e);
          return;
        }
      }
      if (isNull(option.text)) continue;
      if (!isNull(this.value) && (this.value + "") == (option.value + "") && this._jqObj)
        this._jqObj.find("input").val(option.text);
      this.options.push(option);

      //如果要按树形显示
      if (this.dataModel.showTree && this.dataModel.parentNodeIdField
        && (this.dataModel.rootNodeId || this.dataModel.rootNodeId == 0)) {
        this.nodes[option.value] = {
          option: option,
          parentId: row[this.dataModel.parentNodeIdField],
          childs: []
        };
      } else {
        this.nodes[option.value] = {
          option: option
        };
      }
    }
    if (this.options.length == 0) return;
    //如果要按树形显示
    if (this.dataModel.showTree && this.dataModel.parentNodeIdField
      && (this.dataModel.rootNodeId || this.dataModel.rootNodeId == 0)) {
      for (var i = 0; i < this.options.length; i++) {
        let option = this.options[i];
        let node = this.nodes[option.value];
        //如果是一级节点
        if ((node.parentId + "") == (this.dataModel.rootNodeId + "")) {
          this.rootNodes.push(option.value);
        } else {
          let nodeParent = this.nodes[node.parentId];
          if (nodeParent) nodeParent.childs.push(option.value);
        }
      }
    }

    if (this.dataModel.onAfterBindData) {
      try {
        eval(this.dataModel.onAfterBindData);
      } catch (err) {
        console.log(err);
      }
    }
  }

  showTreeNode(divDataList, nodeId, iptVal, prefix) {
    let node = this.nodes[nodeId];
    if (!node) return;
    this.addOptionDiv(divDataList, node.option, iptVal, prefix);
    for (let i = 0; i < node.childs.length; i++) {
      this.showTreeNode(divDataList, node.childs[i], iptVal, prefix + 20);
    }
  }

  addOptionDiv(divDataList, option, iptVal, nodePrefix) {
    let text = option.text;
    if(!text && text!=0) text = option.value;
    if (this.dataModel.enableFilter && !isNull(iptVal)) {
      if (!isNull(option.text) && option.text.indexOf(iptVal) >= 0) {
        text = option.text.replace(iptVal, "<span>" + iptVal + "</span>");
        divDataList.append("<div data-value=\"" + option.value + "\">" + text + "</div>");
      }
      return;
    }
    let treeNodeSetting = "";
    if (this.dataModel.showTree) {
      let node = this.nodes[option.value];
      if (node) {
        treeNodeSetting = " parent-id=\"" + node.parentId + "\"";
        //如果不是默认显示所有节点，且当前节点不是一级节点，则默认隐藏
        if (!this.dataModel.expandAllNode && (node.parentId + "") != (this.dataModel.rootNodeId + ""))
          treeNodeSetting = " style=\"display:none;\"";

        let nodeImage = "<img src=\"" + this._tfp.rootPath + "/src/components/tree/images/transparent.png\" "
          + "style=\"margin-left:" + (nodePrefix + 2) + "px; margin-right:10px;\" />";
        if (node.childs.length > 0) {
          if (this.dataModel.expandAllNode) {
            nodeImage = "<img src=\"" + this._tfp.rootPath + "/src/components/tree/images/toggle-"
              + this._tfp.curPage.contentColorMode + ".png\" "
              + "class=\"tfp-popuplist-tree-node-icon\" style=\"" + "margin-left:" + nodePrefix + "px;\" />";
          } else {
            nodeImage = "<img src=\"" + this._tfp.rootPath + "/src/components/tree/images/expand-"
              + this._tfp.curPage.contentColorMode + ".png\" "
              + "class=\"tfp-popuplist-tree-node-icon\" style=\"" + "margin-left:" + nodePrefix + "px;\" />";
          }
        }
        text = nodeImage + text;
      }
    }
    let ipt = '';
    if (this.dataModel.multiCheck) {
      ipt = '<input type=\"checkbox\">';
      if (this.dataModel.onlyCanSelectFinalNode) {
        if (this.dataModel.showTree) {
          let node = this.nodes[option.value];
          if (node && node.childs.length > 0) {
            ipt = '';
          }
        }
      }
    }
    divDataList.append("<div " + treeNodeSetting + " data-value=\"" + option.value + "\">" + ipt + "" + text + "</div>");
    let newDiv = divDataList.find("div").last();
    var that = this;
    if(this.dataModel.multiCheck) {
      newDiv.find("input").click(function () {
        event.stopPropagation();
        that.onClickOption(divDataList, $(this).parent());
      });
      newDiv.click(function () {
        event.stopPropagation();
        let ipt = $(this).find("input").get(0);
        ipt.checked = !ipt.checked;
        that.onClickOption(divDataList, $(this));
      });
    } else {
      newDiv.click(function () {
        event.stopPropagation();
        that.selectOptionByDiv(this);
      });
    }

    if (this.dataModel.showTree) {
      let nodeDiv = divDataList.find("div[data-value=" + option.value + "]");
      if (nodeDiv.length > 0) {
        let that = this;
        nodeDiv.find(".tfp-popuplist-tree-node-icon").click(function () {
          let nodeId = $(this).parent().attr("data-value");
          let node = that.nodes[nodeId];
          if (!node) return;
          let divDataList = $("#" + that.id + "_PopupListDiv");
          let src = $(this).attr("src");
          if (src.indexOf("expand-dark.png") > 0) {
            $(this).attr("src", "" + that._tfp.rootPath + "/src/components/tree/images/toggle-"
              + that._tfp.curPage.contentColorMode + ".png");
            for (let i = 0; i < node.childs.length; i++) {
              let childId = node.childs[i];
              let childNodeDiv = divDataList.find("div[data-value=\"" + childId + "\"]");
              childNodeDiv.show();
              //childNodeDiv.find(".tfp-popuplist-tree-node-icon").attr("src", "/node_modules/tfp/src/components/tree/images/expand-dark.png");
            }
          } else {
            $(this).attr("src", "" + that._tfp.rootPath + "/src/components/tree/images/expand-"
              + that._tfp.curPage.contentColorMode + ".png");
            for (let i = 0; i < node.childs.length; i++) {
              let childId = node.childs[i];
              that.hideNode(divDataList, childId);
            }
          }
          event.stopPropagation();
        });
      }
    }
  }

  hideNode(divDataList, nodeId) {
    let node = this.nodes[nodeId];
    if (node) {
      let nodeDiv = divDataList.find("div[data-value=\"" + nodeId + "\"]");
      nodeDiv.hide();
      nodeDiv.find(".tfp-popuplist-tree-node-icon").attr("src", "" + this._tfp.rootPath + "/src/components/tree/images/expand-"
        + this._tfp.curPage.contentColorMode + ".png");
      for (let i = 0; i < node.childs.length; i++) {
        let childId = node.childs[i];
        this.hideNode(divDataList, childId);
      }
    }
  }

  /**
   * 检查数据加载参数是否设置正确
   * @returns 
   */
  checkLoadDataArg() {
    if (!this.dataModel.dataListValueFormat) {
      alert("请为[" + this.id + "]设置选项值数据格式！");
      return false;
    }
    return true;
  }

  onAfterBindGridData(data) {
    if(this.grid.dataList.length>0) {
      this.grid.selectRow(0);
    }
  }

  onClickGridCell(rowIndex, colIndex, rowData) {
    this.grid.selectRow(rowIndex);
    this.selectGridData();
  }

  //清空关联输入项
  clearRelationDataSetInput(dataSet, rowIndex, colIndex) {
    let col = dataSet.dataModel.columns[colIndex];
    if(!(col.inputs && col.inputs.length>0)) return;
    for(let j=0; j<col.inputs.length; j++) {
      let ipt = col.inputs[j];
      for(let i=0; i<dataSet.dataModel.columns.length; i++) {
        let col2 = dataSet.dataModel.columns[i];
        if(col2.id==ipt.inputId) {
          dataSet.setCellData(rowIndex, i, "");
        }
      }
    }
  }

  selectGridData() {
    if(!this.dataModel.dataListValueFormat) return;
    let data = this.grid.getSelectedRowData();
    let dataSet = null;
    let rowIndex = -1;
    //如果是可编辑表格里的弹出列表，
    if(this.dataModel.dataSet) {
      dataSet = tfp.get(this.dataModel.dataSet);
      rowIndex = this._jqObj.parent().index();
      let colIndex = this._jqObj.index();
      if(dataSet.showCheckbox) colIndex--;
      if(dataSet.showRowNum) colIndex--;
      //dataSet.selectCell(rowIndex, colIndex);
    }

    let val = null;
    try {
      let valueFormat = this.dataModel.dataListValueFormat;
      if (valueFormat.indexOf("{") < 0 && valueFormat.indexOf("#[") < 0) valueFormat = "{" + valueFormat + "}";
      val = this._tfp.replaceDataField(data, valueFormat);
      if (val) val = this._tfp.exeExpress(val);
    } catch (e) {
      console.log(e);
      return;
    }
    if (isNull(val)) {
      this.value = "";
      //如果设置了关联输入项，则当前组件的值为空，则同步清空关联输入项的值
      //if(dataSet) this.clearRelationDataSetInput(dataSet, rowIndex, colIndex);
      return;
    }
    let text = val;
    if (this.dataModel.dataListTextFormat) {
      try {
        let textFormat = this.dataModel.dataListTextFormat;
        if (textFormat.indexOf("{") < 0 && textFormat.indexOf("#[") < 0) textFormat = "{" + textFormat + "}";
        text = this._tfp.replaceDataField(data, textFormat);
        if (text) text = this._tfp.exeExpress(text);
      } catch (e) {
        console.log(e);
      }
    }
    if (this.dataModel.valueType == "obj") {
      this.dataModel.value = data;
    } else if (this.dataModel.valueType == "text") {
      this.dataModel.value = text;
    } else {
      this.dataModel.value = val;
    }
    this._jqObj.find("input").val(text);
    this._jqObj.find("input").focus();

    //绑定关联输入项的值
    if(this.dataModel.inputs && this.dataModel.inputs.length>0) {
      this.dataModel.inputs.forEach(ipt => {
        let val = data[ipt.fieldName];
        if(tfp.isNull(val)) val = "";
        //如果是在可编辑表格里
        if(dataSet) {
          dataSet.dataModel.columns.forEach((col, _colIndex) => {
            if(col.id==ipt.inputId) {
              dataSet.setCellData(rowIndex, _colIndex, val);
            }
          });
        } else {
          let cpt = tfp.get(ipt.inputId);
          if(cpt) cpt.value = val;
        }
      });
    }
    this.valueOnChange();
    this.exeEventHandler("onChange", val);
  }

  selectOptionDivByIndex(index) {
    if(!this.options || this.options.length==0) return;
    var divDataList = $("#" + this.id + "_PopupListDiv");
    if(divDataList.length==0) return;
    divDataList.children("div").css("background-color", "");
    let selectedDiv = divDataList.children("div").eq(index);
    selectedDiv.css("background-color", "#E9EFFB");
    this.selectedIndex = index;
    if((index+1)*24 > divDataList.height()) {
      divDataList.get(0).scrollTop =  index*24 - (divDataList.height() - 30);
    } else if(index==0) {
      divDataList.get(0).scrollTop =  index*24;
    }
  }

  selectOptionDivByValue(val) {
    if(!this.options || this.options.length==0) return;
    var that = this;
    var divDataList = $("#" + this.id + "_PopupListDiv");
    divDataList.children("div").css("background-color", "");
    divDataList.children("div").each(function() {
      let optionVal = $(this).attr("data-value");
      if(optionVal==val) {
        $(this).css("background-color", "#E9EFFB");
        that.selectedIndex = $(this).index();
      }
    });
  }

  selectOptionByIndex(index) {
    var divDataList = $("#" + this.id + "_PopupListDiv");
    this.selectOptionByDiv(divDataList.children("div").eq(index));
  }

  selectOptionByDiv(div) {
    let val = $(div).attr("data-value");
    if (this.showTree) {
      let node = this.nodes[val];
      //如果只能选择末级节点，但当前节点不是末级，则退出
      if (node && node.childs.length > 0 && this.onlyCanSelectFinalNode) {
        return;
      }
    }
    this.value = val;
    var divDataList = $("#" + this.id + "_PopupListDiv");
    divDataList.empty();
    divDataList.hide();
  }

  onClickOption(divDataList, divOption) {
    var val = divOption.attr("data-value");
    if (this.showTree) {
      let node = this.nodes[val];
      //如果只能选择末级节点，但当前节点不是末级，则退出
      if (node && node.childs.length > 0 && this.onlyCanSelectFinalNode) {
        return;
      }
    }

    let obj = [];
    let value = [];
    let text = [];
    for (var j = 0; j < divDataList.find("input").length; j++) {
      let ipt = divDataList.find("input").eq(j);
      let dataVal = ipt.parent("div").attr("data-value");
      if (ipt.prevObject[j].checked) {
        for (var i = 0; i < this.dataModel.options.length; i++) {
          let option = this.dataModel.options[i];
          if ((option.value + "") == (dataVal + "")) {
            obj.push(option);
            value.push(option.value);
            if (option.text) {
              text.push(option.text);
            } else {
              text.push(option.value);
            }
          }
        }
      } else {
        continue;
      }
    }
    if (obj.length == 0 || value.length == 0 || text.length == 0) {
      this.value = '';
    } else {
      if (this.dataModel.valueType == "obj") {
        this.value = obj;
      } else if (this.dataModel.valueType == "text") {
        this.value = text.join(',');
      } else {
        this.value = value.join(',');
      }
    }
    this._jqObj.find("input").val(text.join(','));
  }

  showOptions(isFilter) {
    if(this._tfp.isDesigning) return;
    var divDataList = $("#" + this.id + "_PopupListDiv");
    if (this.dataModel.showTable && this.dataModel.columns && this.dataModel.columns.length > 0 && this.grid) {
      this.grid.loadData();
    } else {
      if (!this.options || this.options.length == 0) return;
      var iptVal = this._jqObj.find("input").val().trim();
      let leg = divDataList.find("div").length;
      if (!this.dataModel.multiCheck || (this.dataModel.multiCheck && leg == 0) || iptVal == '') {
        divDataList.empty();
        /*if(iptVal=="") {
          divDataList.hide();
          return;
        }*/
        if (!this.dataModel.required) {
          divDataList.append("<div data-value=\"\"></div>");
        }
        if (this.dataModel.showTree) {
          for (var i = 0; i < this.rootNodes.length; i++) {
            this.showTreeNode(divDataList, this.rootNodes[i], iptVal, 0);
          }
        } else {
          for (var i = 0; i < this.options.length; i++) {
            var option = this.options[i];
            this.addOptionDiv(divDataList, option, iptVal);
          }
        }
      }
      var that = this;

      if (this.dataModel.multiCheck) {
        //如果当前有值，需要绑定值
        let vals = [];
        if(!this._tfp.isNull(this.dataModel.value)) {
          if(Array.isArray(this.dataModel.value)) {
            vals = this.dataModel.value;
          } else if(typeof(this.dataModel.value)=="string") {
            vals = this.dataModel.value.split(",");
          }
        }
        divDataList.find("input").each(function() {
          let val = $(this).parent().attr("data-value");
          if(vals.includes(val)) {
            this.checked = true;
          } else {
            this.checked = false;
          }
        });
      }
      if(isFilter || this._tfp.isNull(this.value)) {
        if(!this.showTable) this.selectOptionDivByIndex(0);
      } else {
        this.selectOptionDivByValue(this.value);
      }
    }
    //如果列表向下显示没有空间了，则向上显示
    let iptTop = this._jqObj.find("input").offset().top;
    let scrollTop = $(document).scrollTop();
    let listHeight = divDataList.height();
    let docHeight = document.documentElement.clientHeight;
    let listTop = iptTop + 25;
    if((listTop - scrollTop + listHeight)>docHeight) {
      listTop = iptTop - listHeight - 5;
    }
    divDataList.css("left", (this._jqObj.find("input").offset().left-3) + "px");
    divDataList.css("top", listTop + "px");
    $(".tfp-popuplist-datalist").hide();
    $(".tfp-popuplist-table").hide();
    divDataList.show();
  }

  initRuntime() {
    let that = this;

    if (this.readonly) {
      this._jqObj.css("padding-left", "0px");
      this._jqObj.find("img").css("display", "none");
      this._jqObj.find("input").css("padding-left", "0px");
    }

    /*这块的代码应该是没有用的，因为div没有失去焦点事件
    this._jqObj.blur(function () {
      if (that.readonly || that.disabled) return;

      let val = $(this).val().trim();
      that.dataModel.value = val;
      that.valueOnChange();
      that.exeEventHandler("onChange", val);
    });*/

    this._jqObj.find("input").click(function () {
      if(that.dataModel.dataSet) {
        let dataSet = tfp.get(that.dataModel.dataSet);
        if(dataSet) {
          let rowEl = $(this).closest(".tfp-dataset-row");
          dataSet.selectRow(rowEl.index());
          that.dataSetRowIndex = rowEl.index();
        }
      }
      if (that.disabled || that.readonly) return;
      if(that.dataModel.dataSet && that._jqObj.attr("cpt-disable")=="true") return;
      try {
        if (that.dataModel.onClick) eval(that.dataModel.onClick);
      } catch (err) {
        console.log(err.message);
      }
      if (that.readonly) return;
      that.showOptions();
      event.stopPropagation();
    });

    this._jqObj.find("img").click(function () {
      if (that.disabled || that.readonly) return;
      if(that.dataModel.dataSet && that._jqObj.attr("cpt-disable")=="true") return;
      try {
        if (that.dataModel.onClick) eval(that.dataModel.onClick);
      } catch (err) {
        console.log(err.message);
      }
      if (that.readonly) return;

      if (that._jqObj.children("img").attr("src").slice(-14).slice(0, 5) != 'close') that.showOptions();
      event.stopPropagation();
    });

    this._jqObj.hover(function () {
      if(that.disabled || that.readonly) return;
      if(that.dataModel.dataSet && that._jqObj.attr("cpt-disable")=="true") return;
      if(that._tfp.curPage.bgColorMode=="light" && !that.dataModel.dataSet) {
        that._jqObj.css("background-color", "#F6F6F6");
        that._jqObj.find("input").css("background-color", "#F6F6F6");
      }
      if (that._jqObj.children("input").val() != '') {
        that._jqObj.children("img").attr('src', '' + that._tfp.rootPath
          + '/src/components/select/images/close-'
          + that._tfp.curPage.contentColorMode + '.png');
      }
      that._jqObj.children("img").on('click', function (e) {
        if (that._jqObj.children("input").val() != '') {
          e.stopPropagation();
          that.value = '';
          that.showOptions();
        }
      })
    }, function () {
      that._jqObj.children("img").attr('src', '' + that._tfp.rootPath
        + '/src/components/select/images/arrow-down-'
        + that._tfp.curPage.contentColorMode + '.png');
      if(that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light" && !that.dataModel.dataSet && !that._jqObj.find("input").is(":focus")) {
        that._jqObj.css("background-color", "");
        that._jqObj.find("input").css("background-color", "");
      }
    });

    this._jqObj.find("input").focus(function () {
      if (that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light" && !that.dataModel.dataSet) 
        that._jqObj.css("outline", "1px solid var(--sys-theme-color)");
      try {
        if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
      } catch (err) {
        console.log(err.message);
      }
    });

    this._jqObj.find("input").blur(function () {
      if (that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light" && !that.dataModel.dataSet) {
        that._jqObj.css("outline", "0");
        that._jqObj.css("background-color", "");
        that._jqObj.find("input").css("background-color", "");
      }

      //如果启用了过滤，则失去焦点时，需要检查输入框里的文字是否有对应的选项值，如果没有，则需要清空
      if (that.enableFilter && !that.showTable) {
        var val = $(this).val().trim();
        let isValidVal = false;
        for (var i = 0; i < that.options.length; i++) {
          if (that.options[i].text == val) {
            isValidVal = true;
            break;
          }
        }
        if(!isValidVal) {
          that.value = "";
        }
      }

      try {
        if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
      } catch (err) {
        console.log(err.message);
      }
    });

    document.addEventListener("click", function () {
      if($(event.srcElement).closest(".tfp-popuplist-table").length>0 
        && $(event.srcElement).closest(".tfp-grid-footer").length>0) return;
      if (!$(event.target).is($('.tfp-popuplist-datalist'))) $(".tfp-popuplist-datalist").hide();
      if (!$(event.target).is($('.tfp-popuplist-table'))) $(".tfp-popuplist-table").hide();
    });

    document.addEventListener("keydown", function () {
      event.stopPropagation();
      var divDataList = $("#" + that.id + "_PopupListDiv");
      if(!divDataList.is(":visible")) return;
      if(that.dataModel.showTable) {
        if(event.keyCode=="13") {
          //if(event.srcElement.tagName=="INPUT") return;
          that.selectGridData();
          $(".tfp-popuplist-table").hide();
        } else if(event.keyCode=="27") {
          $(".tfp-popuplist-table").hide();
        } else if(event.keyCode=="38") {
          let sltIndex = that.grid.selectedRowIndex;
          if(sltIndex<=0) return;
          that.grid.selectRow(sltIndex-1, true);
        } else if(event.keyCode=="40") {
          let sltIndex = that.grid.selectedRowIndex;
          if(sltIndex>=that.grid.dataList.length) return;
          that.grid.selectRow(sltIndex+1, true);
        }
      } else {
        if(event.keyCode=="13") {
          //if(event.srcElement.tagName=="INPUT") return;
          if(that.selectedIndex>=0) {
            that.selectOptionByIndex(that.selectedIndex);
          }
        } else if(event.keyCode=="27") {
          $("#" + that.id + "_PopupListDiv").hide();
        } else if(event.keyCode=="38") {
          let sltIndex = that.selectedIndex;
          if(sltIndex<=0) return;
          that.selectOptionDivByIndex(sltIndex-1);
        } else if(event.keyCode=="40") {
          let sltIndex = that.selectedIndex;
          if(sltIndex>=that.options.length) return;
          that.selectOptionDivByIndex(sltIndex+1);
        }
      }
    });

    if (this.enableFilter) {
      this._jqObj.find("input").bind("input", function () {
        if (that.readonly || that.disabled) return;
        if(that.showTable) {
          if(that.grid && that.grid.dataModel.loadDataService) {
            let serviceCpt = that._tfp.get(that.grid.dataModel.loadDataService);
            if(serviceCpt) {
              if(!serviceCpt.argSettings) serviceCpt.argSettings = [];
              let keyWordArgSetting = null;
              let keyWordArgName = "keyword";
              if(that.dataModel.filterArgName) keyWordArgName = that.dataModel.filterArgName;
              //如果是可编辑表格，判断请求参数里是否有当前行变量，如果有，需要替换
              if(that.dataModel.dataSet) {
                let dataSet = tfp.get(that.dataModel.dataSet);
                if(dataSet) {
                  let rowEl = that._jqObj.closest(".tfp-dataset-row");
                  that.dataSetRowIndex = rowEl.index();
                }
              }
              serviceCpt.argSettings.forEach(argSetting => {
                if(argSetting.name==keyWordArgName) keyWordArgSetting = argSetting;
                if(that.dataModel.dataSet && that.dataModel.dataQuerySetting.requestArgs 
                  && that.dataModel.dataQuerySetting.requestArgs.length>0) {
                  that.dataModel.dataQuerySetting.requestArgs.forEach(reqArg => {
                    if(reqArg.name==argSetting.name && reqArg.type=="Expression" && reqArg.value.indexOf("{_rowIndex}")>0) {
                      argSetting.value = reqArg.value.replace("{_rowIndex}", that.dataSetRowIndex);
                    }
                  });
                }
              });
              if(!keyWordArgSetting) {
                keyWordArgSetting = {
                  "name": keyWordArgName,
                  "type": "Default",
                  "autoReload": false,
                  "encrypt": false
                };
                serviceCpt.argSettings.push(keyWordArgSetting);
              }
              keyWordArgSetting.value = (that._jqObj.find("input").val()+'').replaceAll("'","");
              var divDataList = $("#" + that.id + "_PopupListDiv");
              divDataList.show();
              that.grid.reloadData();
            }
          }
        } else {
          that.showOptions(true);
        }
      });

      if (!(this.readonly || this.disabled)) this._jqObj.find("input").removeAttr("readonly");
    }

    let dataListDivWidth = this._jqObj.width() + 6;
    if (this.dataModel.dataListDivWidth) dataListDivWidth = this.dataModel.dataListDivWidth;
    //如果显示多列表格，且翻页，最小宽度不能少于480
    if (this.dataModel.showTable && this.dataModel.allowPaging && dataListDivWidth<480) dataListDivWidth = 480;
    let dataListDivHeight = 240;
    if (this.dataModel.dataListDivHeight) dataListDivHeight = this.dataModel.dataListDivHeight;
    this._tfp.use('Panel', function () {
      let panelModel = {
        "id": that.id + "_PopupListDiv",
        "type": "Panel",
        "styles": {
          "width": dataListDivWidth,
          "height": dataListDivHeight,
          "display": "none"
        }
      };
      let panelDataList = that._tfp.render(panelModel, that._tfp.curPage);

      //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
      if (that.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
        || that.dataModel.loadDataService || (that.dataModel.dataQuerySetting
          && (that.dataModel.dataQuerySetting.servicePath || that.dataModel.dataQuerySetting.serviceCpt)
        )) {
        if (that.dataModel.showTable && that.dataModel.columns && that.dataModel.columns.length > 0) {
          $("#" + that.id + "_PopupListDiv").addClass("tfp-popuplist-table");
          that._tfp.use('GridView', function () {
            let gridModel = {
              "id": that.id + "_grid1",
              "type": "GridView",
              "showToolBar": false,
              "showKeywordInput": false,
              "showImportButton": false,
              "showExportButton": false,
              "showPrintButton": false,
              "showCustomOrderButton": false,
              "showFilterColButton": false,
              "showHeader": true,
              "headerBold": true,
              "headerBgColor": "#F9F9F9",
              "headerTextColor": "#333333",
              "headerHeight": "40",
              "showRowNum": false,
              "showBorder": true,
              "borderColor": "#E6E6E6",
              "selectedRowBgColor": "#E9EFFB",
              "rowHeight": "45",
              "allowPaging": false,
              "expandAllNode": true,
              "treeColIndex": 0,
              "nodeIdField": "id",
              "parentNodeIdField": "parent_id",
              "rootNodeId": "0",
              "styles": {
                "position": "absolute",
                "width": "100%",
                "left": 0,
                "top": 0,
                "bottom": 0,
                "border": 0
              },
              "columns": that.dataModel.columns,
              "onAfterBindData": that.id+".onAfterBindGridData(data)",
              "onCellClick": that.id+".onClickGridCell(rowIndex, colIndex, rowData)",
              "dataQuerySetting": that.dataModel.dataQuerySetting,
              "notAutoLoadData": true
            };
            //如果是可编辑表格，判断请求参数里是否有当前行变量，如果有，需要替换
            if(that.dataModel.dataSet) {
              let dataSet = tfp.get(that.dataModel.dataSet);
              if(dataSet && that.dataModel.dataQuerySetting.requestArgs 
                && that.dataModel.dataQuerySetting.requestArgs.length>0) {
                let rowEl = that._jqObj.closest(".tfp-dataset-row");
                that.dataSetRowIndex = rowEl.index();
                let reqArgs = JSON.parse(JSON.stringify(that.dataModel.dataQuerySetting.requestArgs));
                reqArgs.forEach(reqArg => {
                  if(reqArg.type=="Expression" && reqArg.value.indexOf("{_rowIndex}")>0) {
                    reqArg.value = reqArg.value.replace("{_rowIndex}", that.dataSetRowIndex);
                  }
                });
                gridModel.dataQuerySetting.requestArgs = reqArgs;
              }
            }
            if (that.dataModel.allowPaging) gridModel.allowPaging = that.dataModel.allowPaging;
            if (that.dataModel.showRowNum) gridModel.showRowNum = that.dataModel.showRowNum;
            if (that.dataModel.showCheckbox) gridModel.showCheckbox = that.dataModel.showCheckbox;
            if (that.dataModel.rowHeight) gridModel.rowHeight = that.dataModel.rowHeight;
            that.grid = that._tfp.render(gridModel, panelDataList);
            that.grid.initRuntime();
          });
        } else {
          $("#" + that.id + "_PopupListDiv").addClass("tfp-popuplist-datalist");
          //如果是可编辑表格里的弹出列表，则不需要在此加载数据，由可编辑表格统一加载
          if(that.dataModel.dataSet) return;
          that.loadData();
        }
      } else {
        $("#" + that.id + "_PopupListDiv").addClass("tfp-popuplist-datalist");
      }
    });
  }
}