import FileUploadRender from '../fileupload/render.js'

export default class PhotoUploadRender extends FileUploadRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let btnText = '上传图片';
    if (this.dataModel.btnText) btnText = this.dataModel.btnText;
    if (this._tfp.isDesigning) {
      html += indent + "\t<input type=\"button\" value=\"" + btnText + "\" "
        + "class=\"tfp-button tfp-button-primary\" style=\"line-height:30px;\" />\r\n";
    } else {
      //如果手机客户端是任讯APP
      if (this._tfp.curPage.dataModel.mobileType == "TaskMsg") {
        html += indent + `\r\n<div class="panel-box" style="width: 100%;padding-left: 10px;padding-top: 10px;cursor: pointer;display: flex;align-items: center;  flex-wrap: wrap;">`;
        html += `
          <div class="image_box addImage_box" style="width: 100px;height:100px;align-items: center;justify-content: center;margin-bottom: 10px;background: #F7F7F7;margin-right: 10px;display:` + (this.dataModel.allowAdd ? 'none' : 'flex') + `;position: relative;">
            <div class="tfp-photoupload-add"><img src='/node_modules/tfp/src/components/photoupload/images/icon-add.png'></div>
          </div>`;
        html += `</div>`;
      } else {
        if (!this.dataModel.readonly) {
          html += indent + "\t<div class=\"tfp-photoupload-row\">"
            + "<p><input type=\"button\" value=\"" + btnText + "\" "
            + "class=\"tfp-button tfp-button-primary\" style=\"line-height:30px;\" /></p>"
            + "</div>\r\n";
        }
        html += indent + "\t<div class=\"tfp-photoupload-images\">\r\n";
        if (this.dataModel.value) {
          for (var i = 0; i < this.dataModel.value.length; i++) {
            let fileInfo = this.dataModel.value[i];
            html += indent + "\t\t<div class=\"tfp-photoupload-image\" "
              + "style=\"margin:" + this.dataModel.imageMargin + "px; \">"
              + "<img src=\"/Download?fileCode=" + fileInfo.code + "\" width=\""
              + this.dataModel.imageWidth + "\" height=\"" + this.dataModel.imageHeight + "\"";
            if (this.dataModel.allowShowBigImage) {
              html += " onclick=\"tfp.openPage('查看图片','/Download?fileCode="
                + fileInfo.code + "')\" style=\"cursor:pointer;\"";
            }
            html += "/></div>\r\n";
          }
        }
        html += indent + "\t</div>\r\n";
      }
    }
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}