import FileUploadRender from '../fileupload/render.js'

export default class PhotoUploadRender extends FileUploadRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let btnText = '上传图片';
    if (this.dataModel.btnText) btnText = this.dataModel.btnText;
    let imgUrl = "";
    if (this._tfp.isDesigning) {
      imgUrl = "../tfp/src/components/photoupload/images/icon.png";
      html += indent + "\t<div class=\"tfp-button tfp-button-primary tfp-button-rect\" style=\"line-height:30px;\">"
        +"<img src=\""+imgUrl+"\" style=\"width:16px; height:16px; margin-right:7px;\">" + btnText + "</div>\r\n";
    } else {
      imgUrl = "/node_modules/tfp/src/components/fileupload/images/icon.png";
      if (!this.dataModel.readonly) {
        html += indent + "\t<div class=\"tfp-photoupload-row\">"
          + indent + "\t\t<div class=\"tfp-button tfp-button-primary tfp-button-rect\" style=\"line-height:30px;\">"
          +"<img src=\""+imgUrl+"\" style=\"width:16px; height:16px; margin-right:7px;\">" + btnText + "</div>\r\n"
          + "</div>\r\n";
      }
      html += indent + "\t<div class=\"tfp-photoupload-images\">\r\n";
      if (this.dataModel.value) {
        for (var i = 0; i < this.dataModel.value.length; i++) {
          let fileInfo = this.dataModel.value[i];
          html += indent + "\t\t<div class=\"tfp-photoupload-image\" "
            + "style=\"margin:" + this.dataModel.imageMargin + "px; \">"
            + "<img src=\"/Download?fileCode=" + fileInfo.code + "\" width=\""
            + this.dataModel.imageWidth + "\" height=\"" + this.dataModel.imageHeight + "\"";
          if (this.dataModel.allowShowBigImage) {
            html += " onclick=\"tfp.openPage('查看图片','/Download?fileCode="
              + fileInfo.code + "')\" style=\"cursor:pointer;\"";
          }
          html += "/></div>\r\n";
        }
      }
      html += indent + "\t</div>\r\n";
    }
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}