import FileUploadRender from '../fileupload/render.js'

export default class PhotoUploadRender extends FileUploadRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    html += indent + `\r\n<div class="wx-panel" style="width: 100%;padding-left: 1%;padding-top: 1%;cursor: pointer;display: flex;align-items: center;flex-wrap: wrap;">`
    html += `
      <div class="image_box addImage_box" style="width: `+ this.dataModel.imageWidth + `%;height: ` + this.dataModel.imageHeight + `px;align-items: center;justify-content: center;margin-bottom: 1%;background: #F7F7F7;margin-right: 1%;display:` + (this.dataModel.allowAdd ? 'none' : 'flex') + `;">
        <view class="wx-photoupload-add"></view>
      </div>
      <div class="image_box delImage_box" style="width: `+ this.dataModel.imageWidth + `%;height:` + this.dataModel.imageHeight + `px;align-items: center;justify-content: center;margin-bottom: 1%;background: #F7F7F7;margin-right: 1%;display:` + (this.dataModel.allowDelete ? 'none' : 'flex') + `;">
        <view class="wx-photoupload-minus"></view>
      </div>`;
    html += `
    </div>`;
    return html + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var vid = escape(this.dataModel.id).replaceAll("%", "");
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    bodyHtml += indent + "";
    bodyHtml += `  <view class="wx-photoupload-outbox" style="padding:` + this.dataModel.imageMargin + `% ` + this.dataModel.imageMargin + `% 0 0;">
      <view class="wx-photoupload-innerbox" style="width:`+ this.dataModel.imageWidth + `%;height:` + this.dataModel.imageHeight * 2 + `rpx;margin-left:` + this.dataModel.imageMargin + `%;margin-bottom:` + this.dataModel.imageMargin + `%;" wx:for="{{` + vid + `_uploadImageList}}" wx:for-item="items" wx:key="id">
        <view class="wx-photoupload-imageitem" style="height:`+ this.dataModel.imageHeight * 2 + `rpx;" bindtap="bindclick_seeBiggerImage"  data-src="{{items.src}}" data-type="image">
          <image src="{{items.src}}" mode="aspectFill"/>
        </view>`;
    if (!this.dataModel.allowDelete) {
      bodyHtml += `
        <view class="wx-photoupload-closebox" bindtap="bindclick_delFile" data-type="image" data-index="{{index}}" wx:if="{{` + vid + `_showUploadDel}}" data-array="` + vid + `_uploadImageList">
          <view>
            <view class="wx-photoupload-delete"></view>
          </view>
        </view>`;
    }
    bodyHtml += `\n</view>\n`;
    if (!this.dataModel.allowAdd) {
      bodyHtml += `<view class="wx-photoupload-innerbox" style="width:` + this.dataModel.imageWidth + `%;height:` + this.dataModel.imageHeight * 2 + `rpx;margin-left:` + this.dataModel.imageMargin + `%;margin-bottom:` + this.dataModel.imageMargin + `%;">
      <view class="wx-photoupload-imagebox"  style="height:`+ this.dataModel.imageHeight * 2 + `rpx;" bindtap="bindclick_uploadFile" data-type="image" data-array="` + vid + `_uploadImageList" data-number="` + this.dataModel.size + `" data-appCode="` + this.dataModel.appCode + `">
       <view class="wx-photoupload-add"></view>
      </view>
    </view>`;
    }
    if (!this.dataModel.allowDelete) {
      bodyHtml += `<view wx:if="{{`+ vid +`_uploadImageList.length>0}}" class="wx-photoupload-innerbox" style="width:` + this.dataModel.imageWidth + `%;height:` + this.dataModel.imageHeight * 2 + `rpx;margin-left:` + this.dataModel.imageMargin + `%;margin-bottom:` + this.dataModel.imageMargin + `%;">
        <view class="wx-photoupload-imagebox" style="height:`+ this.dataModel.imageHeight * 2 + `rpx;" bindtap="bindclick_switchDel" data-array="` + vid + `_uploadImageList" data-type="image" data-delname="` + vid + `_showUploadDel">
          <view class="wx-photoupload-minus"></view>
        </view>
      </view>\n`
    }
    bodyHtml += `</view>\r`;
    cpt_wx.wxml = bodyHtml + indent;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", false, parentIndent, retainStyleAttr, otherOptions);
  }
}