export default {
  "name": "PhotoUpload",
  "comment": "图片上传",
  "cssFiles": ["style.css", "../button/style.{bgColorMode}.css"],
  "attrs": [
    {
      "name": "btnText",
      "comment": "按钮文本",
      "type": "String",
      "default": "上传图片"
    },
    {
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    },
    {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    },
    {
      "name": "appCode",
      "comment": "应用代码",
      "type": "String"
    },
    {
      "name": "appDataId",
      "comment": "应用数据ID",
      "type": "String"
    },
    {
      "name": "enIde",
      "comment": "启用身份验证",
      "type": "Switch"
    },
    {
      "name": "onlyOne",
      "comment": "保持唯一",
      "type": "Switch"
    },
    {
      "name": "size",
      "comment": "文件总数",
      "type": "Number",
      "default": 10
    },
    {
      "name": "imageWidth",
      "comment": "图片显示宽度",
      "type": "Number",
      "required": true,
      "default": "90"
    },
    {
      "name": "imageHeight",
      "comment": "图片显示高度",
      "type": "Number",
      "required": true,
      "default": "90"
    },
    {
      "name": "imageMargin",
      "comment": "图片边距",
      "type": "Number",
      "required": true,
      "default": "10"
    },
    {
      "name": "allowShowBigImage",
      "comment": "允许点击查看大图",
      "type": "Switch",
      "default": true
    },
    {
      "name": "allowDelete",
      "comment": "隐藏删除",
      "type": "Switch",
      "default": false
    },
    {
      "name": "allowAdd",
      "comment": "隐藏添加",
      "type": "Switch",
      "default": false
    },
    {
      "name": "compress",
      "comment": "压缩图片",
      "type": "Switch",
      "default": true
    },
    {
      "name": "maxSize",
      "comment": "图片最大尺寸",
      "type": "Number",
      "required": true,
      "default": "960"
    }
  ],
  "defaultStyles": {
    "background": "white",
    "min-height": '120px',
    "width": "100%"
  },
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时"
    }, {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }, {
      "name": "onBeforeUpload",
      "comment": "上传前",
      "isNotHtmlEvent": true
    }, {
      "name": "onAfterUpload",
      "comment": "上传后",
      "isNotHtmlEvent": true
    }]
}