import FileUpload from "../fileupload/controller.js";

/**
 * 图片上传组件
 * @param {[type]} dataModel [description]
 */
export default class PhotoUpload extends FileUpload {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, dataModel, parent, "PhotoUpload");
  }

  get btnText() { return this.dataModel.btnText ? this.dataModel.btnText : "上传图片" }
  set btnText(value) {
    this.dataModel.btnText = value;
    if (this._jqObj) {
      this._jqObj.find(".tfp-button").val(value);
      this.exeEventHandler("onChange");
    }
  }

  get value() {
    let val = [];
    if (!this.files) this.files = [];
    for (var i = 0; i < this.files.length; i++) {
      let f = this.files[i];
      val.push({
        name: f.name,
        code: f.code,
        size: f.size,
        appCode: this.appCode,
        appDataId: this.appDataId
      });
    }
    this.dataModel.value = val;
    return val;
  }
  set value(value) {
    if (!value) return;
    let val = value;
    if (typeof (val) == "string") {
      if (val.startsWith("[") && val.endsWith("]")) {
        val = JSON.parse(val);
      } else {
        //如果绑定的是某一个附件的附件代码，则查询该附件的信息
        const regex = /^[A-Za-z0-9]{32}$/;
        if (regex.test(val)) {
          this.onAfterBindData({
            fileCode: val
          });
          return;
        }
      }
    }
    if (!Array.isArray(val)) return;
    this.files = val;
    this.dataModel.value = val;
    if (this._jqObj) {
      this._jqObj.find(".tfp-photoupload-images").empty();
      let imgList = [];
      for (var i = 0; i < this.dataModel.value.length; i++) {
        let fileInfo = this.dataModel.value[i];
        imgList.push(fileInfo.code);
        let imgHtml = "<div class=\"tfp-photoupload-image\" style=\"margin:" + this.dataModel.imageMargin + "px; \">"
          + "<img src=\"/Download?fileCode=" + fileInfo.code + "\" data-index=" + i + " width=\"" + this.dataModel.imageWidth
          + "\" height=\"" + this.dataModel.imageHeight + "\"";
        // if (this.dataModel.allowShowBigImage) {
        //   imgHtml += " onclick=\"tfp.openImage('/Download?fileCode="
        //     + fileInfo.code + "&showImage=true')\" style=\"cursor:pointer;\"";
        // }
        imgHtml += "/>";
        if (this.dataModel.allowDelete) {
          imgHtml += "<p align=\"center\"><a href=\"javascript:void(0)\" "
            + "file-code=\"" + fileInfo.code + "\">删除</a></p>";
        }
        imgHtml += "</div>";
        this._jqObj.find(".tfp-photoupload-images").append(imgHtml);
      }
      let that = this;

      if (this.dataModel.allowDelete) {
        this._jqObj.find("a").click(function () {
          that.deleteFile(this, $(this).attr("file-code"));
        });
      }
      if (this.dataModel.allowShowBigImage) {
        this._jqObj.find("img").click(function () {
          tfp.openImage(JSON.stringify(imgList), $(this).attr("data-index"));
        })
      }
      this.exeEventHandler("onChange");
    }
  }

  //保持唯一
  get onlyOne() { return this.dataModel.onlyOne }
  set onlyOne(value) {
    this.dataModel.onlyOne = value;
    this.dataModel.size = 1;
    if (this._tfp.isDesigning && this.dataModel.onlyOne) {
      uiDesigner.setCurCptAttrSettingVal("size", "1");
    }
  }

  //是否只读
  get readonly() { return this.dataModel.readonly }
  set readonly(value) {
    this.dataModel.readonly = value ? true : false;
    if (!this.dataModel.readonly) delete this.dataModel.readonly;
    if (this._jqObj && this.dataModel.readonly && !this._tfp.isDesigning) {
      this._jqObj.find(".tfp-photoupload-row").hide();
    }
  }

  //是否可以查看大图
  get allowShowBigImage() { return this.dataModel.allowShowBigImage }
  set allowShowBigImage(value) {
    this.dataModel.allowShowBigImage = value;
  }

  get imageWidth() { return this.dataModel.imageWidth }
  set imageWidth(value) {
    this.dataModel.imageWidth = value;
    if (this._jqObj) {
      this._jqObj.find(".tfp-photoupload-image").find("img").css("width", value + "px");
    }
  }

  get imageHeight() { return this.dataModel.imageHeight }
  set imageHeight(value) {
    this.dataModel.imageHeight = value;
    if (this._jqObj) {
      this._jqObj.find(".tfp-photoupload-image").find("img").css("height", value + "px");
    }
  }

  get imageMargin() { return this.dataModel.imageMargin }
  set imageMargin(value) {
    this.dataModel.imageMargin = value;
    if (this._jqObj) {
      this._jqObj.find(".tfp-photoupload-image").find("img").css("margin", value + "px");
    }
  }

  //是否压缩图片
  get compress() { return this.dataModel.compress ? true : false }
  set compress(value) {
    this.dataModel.compress = value ? true : false;
  }

  get maxSize() { return this.dataModel.maxSize }
  set maxSize(value) {
    this.dataModel.maxSize = value;
  }

  selectFile() {
    if (!this.size) this.size = 10;
    if (this.size && this.files && this.files.length >= this.size) {
      this._tfp.showMsg("最多只能上传" + this.size + "张图片！");
      return;
    }
    let imagesDiv = this._jqObj.find(".tfp-photoupload-images");
    imagesDiv.append("<div class=\"tfp-photoupload-image\" style=\"margin:"
      + this.dataModel.imageMargin + "px;display:none\">"
      + "<img width=\"" + this.dataModel.imageWidth + "\" height=\"" + this.dataModel.imageHeight + "\" />"
      + "<input type=\"file\" style=\"display:none\" />"
      + "<p><progress value=\"0\" max=\"100\"></progress>&nbsp;"
      + "<span class=\"uploaderPercent\">0%</span></p></div>");
    let that = this;
    let ipt = imagesDiv.find(".tfp-photoupload-image").last().find("input");
    ipt.change(function () {
      that.uploadFile(this);
    });
    ipt.click();
  }

  onAfterBindData(data) {
    let args = {};
    if (data && data.fileCode) {
      args.file_code = data.fileCode;
    } else if (this.dataModel.appCode && this.dataModel.appDataId) {
      args.app_code = this.dataModel.appCode;
      args.app_data_id = this.dataModel.appDataId;
    }
    //应用代码和应用数据id都设置了才能自动查询附件信息
    if (!(args.file_code || (args.app_code && args.app_data_id))) return;

    let that = this;
    this._tfp.use("Service", function () {
      var service = that._tfp["new"]("Service");

      service.path = "sys/service/app_attach/getUploadCptVal.tbs";
      service.request(args, function (req, res) {
        if (!res.data) return;
        that.value = res.data;
      });
    });
  }

  initRuntime() {
    let that = this;
    this._jqObj.find(".tfp-photoupload-row").find(".tfp-button").click(function () {
      if (that.readonly || that.disabled) return;
      that.selectFile();
    });
  }
}